#include <cmath>
#include "randomplayer.h"

RandomPlayer::RandomPlayer()
{
	type = "random";
	name = "Randomak";
        rg.setSeed(-1); // fully random play
}

int RandomPlayer::play(){
	return pickRandom(getLegalList());
}

int RandomPlayer::talon(){
	QList<int> legal;
	foreach(int c,hand){
		if(Card::value(c)!="10" && Card::value(c)!="eso" && c!=stav->hra.tromf)
			legal.push_back(c);
	}
	return pickRandomTwo(legal);
}

int RandomPlayer::bid(){
	int bids=0;
	if(hand.contains(stav->hra.tromf7()))
		if(rg.rand((int)log2(stav->hra.flekNaSedmu+1)+3)==0)bids|=2;
	if(rg.rand((int)log2(stav->hra.flekNaStovku+1)+3)==0)bids|=1;
	if(rg.rand(stav->hra.flekNaHru+1)==0)bids|=4;
	return bids;
}

int RandomPlayer::tromf(){
	return pickRandom(hand);
}

int RandomPlayer::pickRandom(QList<int> legal){
	return legal.at(rg.rand(legal.count()));
}

int RandomPlayer::pickRandomTwo(QList<int> legal){
	int i = rg.rand(legal.count());
	int k = legal[i];
	legal.removeAt(i);
	int j = rg.rand(legal.count());
	return k*32 + legal[j];
}
