#include "tromfchooser.h"

TromfChooser::TromfChooser()
{
}

void TromfChooser::init()
{
	QFile file("chooseTromf.txt");
	QTextStream in(&file);
	if (!file.open(QIODevice::ReadOnly | QIODevice::Text)){
		qDebug() << "TromfChooser: nejde otvorit subor";
		return;
	}
	int a,b;
	while(!in.atEnd()){
		in >> a >> b;
        this->table.insert(a,b);
	}
	file.close();
	qDebug() << "TromfChooser init OK, table size=" << table.size();
}

void TromfChooser::setHand(QList<int> hand)
{
    this->rozdanie = 0;
    this->mapColors[3]=3;
    // convert list of cards to canonical representation of rozdanie
    int pocty[4] = {0,0,0,0};
    int kartyVoFarbe[4] = {0,0,0,0}; //8 bits represent 8 cards whether are present in particular color
    for(int i=0;i<hand.size();i++){
        pocty[hand[i]/8] ++;
        kartyVoFarbe[hand[i]/8] |= (1 << (7 - hand[i]%8));
    }
    if(this->colorIsLexicoLess(pocty[0],pocty[1],kartyVoFarbe[0],kartyVoFarbe[1])){
        if(this->colorIsLexicoLess(pocty[1],pocty[2],kartyVoFarbe[1],kartyVoFarbe[2])){
            this->mapColors[0]=0;
            this->mapColors[1]=1;
            this->mapColors[2]=2;
        } else {
            if(this->colorIsLexicoLess(pocty[0],pocty[2],kartyVoFarbe[0],kartyVoFarbe[2])){
                this->mapColors[0]=0;
                this->mapColors[1]=2;
                this->mapColors[2]=1;
            } else {
                this->mapColors[0]=1;
                this->mapColors[1]=2;
                this->mapColors[2]=0;
            }
        }
    } else {
        if(this->colorIsLexicoLess(pocty[0],pocty[2],kartyVoFarbe[0],kartyVoFarbe[2])){
            this->mapColors[0]=1;
            this->mapColors[1]=0;
            this->mapColors[2]=2;
        } else {
            if(this->colorIsLexicoLess(pocty[1],pocty[2],kartyVoFarbe[1],kartyVoFarbe[2])){
                this->mapColors[0]=2;
                this->mapColors[1]=0;
                this->mapColors[2]=1;
            } else {
                this->mapColors[0]=2;
                this->mapColors[1]=1;
                this->mapColors[2]=0;
            }
        }
    }



    for(int i=0;i<4;i++){
        this->rozdanie |= (kartyVoFarbe[i] << (8 * (3 - this->mapColors[i])));
    }
}

int TromfChooser::chooseTromf()
{
//    qDebug() << "TromfChooser::chooseTromf(): rozdanie=" << this->rozdanie;
    int chosenTromf = this->table.value(this->rozdanie,-1); //needs to be mapped back with mapColors
    for(int i=0;i<4;i++){
        if(this->mapColors[i] == chosenTromf/8){
            return (i*8 + chosenTromf%8);
        }
    }
    qDebug() << "TromfChooser Fatal: no color mapped to color " << (chosenTromf/8);
    return -1;
}

bool TromfChooser::colorIsLexicoLess(int count1, int count2, int cards1, int cards2)
{
    if(count1 > count2)return true;
    if(count1 < count2)return false;
    return cards1 <= cards2;
}
