#include<QDebug>
#include "choosetromf.h"

// time limit for given 7 cards and given tromf
#define TIME_LIMIT_CASE 5000
#define PRETTY false

ChooseTromf::ChooseTromf()
{
}

unsigned int ChooseTromf::getCardMask(int c){
	return (1 << (31-c));
}

bool ChooseTromf::jeTromfJasny(int ff[4]){
	for(int i=0;i<4;i++)
		if(ff[i]>=5)return true;
	return false;
}

unsigned int ChooseTromf::kandidatiNaTromfa(unsigned int rozdanie){
    int bodyZaFarbu[4] = {0,0,0,0};
	int maxFarba=0;
	for(int i=0;i<4;i++){
		int pocet=0;
		for(int j=0;j<8;j++){
			if(rozdanie & getCardMask(i*8+j))
				pocet++;
		}
		bodyZaFarbu[i] += pocet*pocet*pocet;
		if(rozdanie & getCardMask(i*8+7)) //mam eso
			bodyZaFarbu[i] += 10;
		if(rozdanie & getCardMask(i*8+3)) //mam desiatku
			bodyZaFarbu[i] += 8;
		if((rozdanie & getCardMask(i*8+3))&&(rozdanie & getCardMask(i*8+7))) //mam eso aj desiatku
			bodyZaFarbu[i] += 2;
		if((rozdanie & getCardMask(i*8+5))&&(rozdanie & getCardMask(i*8+6))) //mam hlasku
			bodyZaFarbu[i] += 53;
		if((rozdanie & getCardMask(i*8+5))^(rozdanie & getCardMask(i*8+6))) //trham hlasku
			bodyZaFarbu[i] += 13;

		if(bodyZaFarbu[i]>=bodyZaFarbu[maxFarba])
			maxFarba = i;
	}
    unsigned int kandidati = 0;
	for(int i=0;i<4;i++){
		if(bodyZaFarbu[maxFarba]<13){ //je to uplne prehrata hra, ani netrham ziadnu hlasku
			if(i!=maxFarba)
				continue;
		}

		if(bodyZaFarbu[i]*2>=bodyZaFarbu[maxFarba]){
			//farba i je hodna byt zvolena za tromfa, kandidatska karta bude minimum z tej farby
			//ale este skontrolujem, ci to nie je podmnozina
			bool jePodmnozina[4] = {true,true,true,true};
			bool jeTotozna[4] = {true,true,true,true};
			jePodmnozina[i]=false; //zaujimaju ma len porovnania s inymi farbami
			jeTotozna[i]=false; //zaujimaju ma len porovnania s inymi farbami
			for(int j=0;j<8;j++){
				for(int k=0;k<4;k++){
                    if(k==i)continue;
					// ak nieco je v i a nie je vo farbe k, tak i nie je podmnozina k
					if((rozdanie & getCardMask(i*8+j))&&((rozdanie & getCardMask(k*8+j))==0))
                        jePodmnozina[k] = false;
				}
			}
            for(int k=0;k<4;k++){
                int kartyVI = (rozdanie >> (8*(3-i)))%256;
                int kartyVK = (rozdanie >> (8*(3-k)))%256;
                jeTotozna[k] = (kartyVI==kartyVK);
            }
			bool jePodm = false;
			for(int k=0;k<4;k++){
				if(jePodmnozina[k] && !jeTotozna[k])
					jePodm = true;
				// ak maju dve farby totozne karty,
				// potom staci testovat jednu z nich
				if(jeTotozna[k] && i<k)
                    jePodm = true;
			}
			if(jePodm)
				continue; //i nebude kandidat, kedze je podmnozina k
			for(int j=0;j<8;j++){
				if(rozdanie & getCardMask(i*8+j)){
					kandidati |= getCardMask(i*8+j);
					break;
				}
			}
		}
    }
	return kandidati;
}

void ChooseTromf::generujRecursive(unsigned int rozdanie,int farby[4],int ff[4]){
	if(farby[0]+farby[1]+farby[2]+farby[3]==7){
		// mame vygenerovane rozdanie
        // ak su dve farby s rovnakym poctom kariet, dalsia musi byt lexikograficky dalej
        int kartyVoFarbach[4];
        for(int i=0;i<4;i++){
           kartyVoFarbach[i] = (rozdanie >> ((3-i)*8)) % 256;
        }
        if(kartyVoFarbach[0]>kartyVoFarbach[1] && farby[0]==farby[1])return;
        if(kartyVoFarbach[1]>kartyVoFarbach[2] && farby[1]==farby[2])return;
        // assert kartyVoFarbach[0] <= kartyVoFarbach[1] <= kartyVoFarbach[2]
        this->rozdania.push_back(rozdanie);
		return;
	}
	// nieco chyba z nejakej farby
	for(int ii=0;ii<4;ii++){
        int i=(ii+3)%4; // poradie 3,0,1,2 = cerven, gula, zalud, zelen
        if(farby[i]<ff[i]){
            //idem generovat nejaku moznu kartu z i-tej farby
			farby[i]++;
			int from = i*8;
			for(int j=i*8;j<i*8+8;j++)
				if(rozdanie & getCardMask(j))
					from = j+1; //prva medzera za poslednym pouzitym

			for(int j=from;j<i*8+8;j++){
				if(rozdanie & getCardMask(j))continue;
				generujRecursive(rozdanie | getCardMask(j),farby,ff);
			}
			farby[i]--;
			return;
		}
	}
}

void ChooseTromf::generujRozdania(){
	for(int r=7;r>=0;r--){ //pocet cervenov
		// chceme generovat rozdania len take, kde
		// je viac gul ako zaludov a viac zaludov ako zelenov
		// moze byt aj rovnako, ale potom lexikograficky zapis gul
		// nesmie byt dalej v abecede
		int minGul = (9-r)/3; // minimalny pocet gul
		int maxGul = 7-r; // maximalny pocet gul
		for(int g = minGul;g <= maxGul;g++){
			int minZal = (8-r-g)/2;
			int maxZal = 7-r-g;
			if(maxZal>g)maxZal=g;
			for(int zal = minZal;zal<=maxZal;zal++){
				int zel = 7-r-g-zal; //pocet zelenov
				qDebug() << r << g << zal << zel;
				int farby[4] = {0,0,0,0};
				int ff[4] = {g,zal,zel,r};
//				if(!jeTromfJasny(ff))
				this->generujRecursive(0,farby,ff);
				qDebug() << rozdania.size();
			}
		}
	}
}

QString ChooseTromf::printRozdanie(unsigned int rozdanie,bool detail){
	QString r="";
	for(int i=0;i<32;i++){
		if(rozdanie & getCardMask(i)){
			if(detail)
				r += Card::title(i) + " ";
			else
				r += "1";
		} else {
			if(!detail)
				r += "0";
		}
	}
	return r;
}


void ChooseTromf::ratajOdRozdania(unsigned int rozdanie){
	bool rataj=(rozdanie==0); //ak neni zadane rozdanie, tak sa rata od zaciatku
	qDebug() << "Pocet vsetkych rozdani: " << rozdania.size();

	QFile file("chooseTromf.txt");
	QTextStream out(&file);
	gs.out = &out;
	if (!file.open(QIODevice::WriteOnly | QIODevice::Text)){
		qDebug() << "Nejde otvorit subor";
		return;
	}
	file.close();

	for(int i=0;i<rozdania.size();i++){
		if(rataj){
			if (!file.open(QIODevice::Append | QIODevice::Text)){
				qDebug() << "Nejde otvorit subor";
				return;
			}
			unsigned int kandidati = this->kandidatiNaTromfa(rozdania[i]);
			int poc = 0;
			for(int k=0;k<32;k++){
				if(kandidati & (1 << k))
					poc++;
			}

			out << rozdania[i];
			if(PRETTY){
				out << "\n" << printRozdanie(rozdania[i],true) << "\n";
			}
			int tromf = 31; // local loop pointer to tromf
			qreal maxResult = -9999999;
			int bestTromf =-1;
			while(kandidati>0){
				if(kandidati&1){
					qreal result;
					if(poc>1){
                        result = gs.expectedResult(rozdania[i],tromf,TIME_LIMIT_CASE);
						if(result>maxResult){
							maxResult = result;
							bestTromf = tromf;
						}
					} else {
						// ked je len jeden kandidat, tak je najlespi bezkonkurencne
						bestTromf = tromf;
					}
					if(PRETTY && poc>1){
						out << Card::title(tromf) << ": " << result << "\n";
					}
				}
				tromf--;
				kandidati /= 2;
			}
			if(!PRETTY){
				out << " " << bestTromf << "\n";
			}

			file.close();
		}

		if(rozdania[i]==rozdanie){
			qDebug() << "Skipol som prvych " << i;
			rataj=true;
		}
	}
}
