<?php
function ls($pattern="*", $folder="", $recursivly=false, $options=array('return_files','return_folders')) {
    if($folder) {
        $current_folder = realpath('.');
        if(in_array('quiet', $options)) { // If quiet is on, we will suppress the 'no such folder' error
            if(!file_exists($folder)) return array();
        }
        
        if(!chdir($folder)) return array();
    }
    
    
    $get_files    = in_array('return_files', $options);
    $get_folders= in_array('return_folders', $options);
    $both = array();
    $folders = array();
    
    // Get the all files and folders in the given directory.
    if($get_files) $both = glob($pattern, GLOB_BRACE + GLOB_MARK);
    if($recursivly or $get_folders) $folders = glob("*", GLOB_ONLYDIR + GLOB_MARK);
    
    //If a pattern is specified, make sure even the folders match that pattern.
    $matching_folders = array();
    if($pattern !== '*') $matching_folders = glob($pattern, GLOB_ONLYDIR + GLOB_MARK);
    
    //Get just the files by removing the folders from the list of all files.
    $all = array_values(array_diff($both,$folders));
        
    if($recursivly or $get_folders) {
        foreach ($folders as $this_folder) {
            if($get_folders) {
                //If a pattern is specified, make sure even the folders match that pattern.
                if($pattern !== '*') {
                    if(in_array($this_folder, $matching_folders)) array_push($all, $this_folder);
                }
                else array_push($all, $this_folder);
            }
            
            if($recursivly) {
                // Continue calling this function for all the folders
                $deep_items = ls($pattern, $this_folder, $recursivly, $options); # :RECURSION:
                foreach ($deep_items as $item) {
                    array_push($all, $this_folder . $item);
                }
            }
        }
    }
    
    if($folder) chdir($current_folder);
    return $all;
}

function bsearch($val,$from,$len,&$a)
{
  if(count($a)<$len)throw new Exception("Array length exception");
  if($len==1)return ($a[$from]==$val);
  $mid = $from + (int)($len/2);
  if($val<$a[$mid])return bsearch($val,$from,$mid-$from,$a);
  else return bsearch($val,$mid,$len-($mid-$from),$a);
}

$f = file_get_contents('chooseTromf.txt');
$rozdania = array();
foreach(explode("\n",$f) as $line)
{
  $items = explode(" ",$line);
  if(count($items)!=2)
  {
    continue;
  }
  $rozdania[$items[0]] = $items[1];
}
//echo "Vsetky rozdania: " . count($rozdania) . "\n";

$rozdania2 = array();
foreach(array_reverse(ls()) as $file)
{
  if(substr($file,0,12)!='chooseTromf-')continue;
  //echo "processing file " . $file . "\n";
  $lines = explode("\n",file_get_contents($file));
  foreach($lines as $line)
  {
    $items = explode(" ",$line);
    if(count($items)!=2)
    {
      continue;
    }
    if(!array_key_exists($items[0],$rozdania2))
    {
      $rozdania2[$items[0]] = array();
    }
    $rozdania2[$items[0]] []=$items[1];
  }
}
//echo count($rozdania2) . " rozdani\n";
asort($rozdania);
asort($rozdania2);
foreach($rozdania2 as $k=>$v)
{
  echo $k;
  echo " " . $v[0];
  //foreach($v as $vv)
  //{
  //  echo " ".$vv;
  //}
  echo "\n";
}
?>
