#include "quickgamedialog.h"
#include "ui_quickgamedialog.h"

QuickGameDialog::QuickGameDialog(Game* g, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::QuickGameDialog)
{
	game = g;
    ui->setupUi(this);
    Qt::WindowFlags flags = this->windowFlags();
    flags = Qt::CustomizeWindowHint | Qt::WindowMinimizeButtonHint | Qt::WindowSystemMenuHint | Qt::WindowCloseButtonHint;
    this->setWindowFlags(flags);
	thread = new QuickGameThread(game,ui);
	connect(thread,SIGNAL(progress(int)),this,SLOT(progress(int)));
}

QuickGameDialog::~QuickGameDialog()
{
    delete ui;
	delete thread;
}

void QuickGameDialog::progress(int step){
	if(step>-1)
		ui->progressBar->setValue(step);
    ui->label_6->setText(QString::number(step));
	ui->lcdNumber->display(game->players[0]->peniaze);
	ui->lcdNumber_2->display(game->players[1]->peniaze);
	ui->lcdNumber_3->display(game->players[2]->peniaze);
}

void QuickGameDialog::show(){
	ui->label_2->setText(game->players[0]->name);
	ui->label_3->setText(game->players[1]->name);
	ui->label_4->setText(game->players[2]->name);
	ui->lineEdit->setText(game->settings->value("shuffling/seed",47).toString());
	ui->checkBox->setChecked(game->settings->value("shuffling/random")==1);
	QWidget::show();
}

void QuickGameDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void QuickGameDialog::closeEvent(QCloseEvent *event){
    qDebug() << "quickGame close event";
    thread->terminate();
	game->quickGame = false;
    ui->progressBar->setValue(0);
	game->settings->setValue("shuffling/random",ui->checkBox->checkState()==Qt::Checked?1:0);
	game->settings->setValue("shuffling/seed",ui->lineEdit->text());
	QDialog::close();
}

void QuickGameDialog::reject(){
    qDebug() << "quickGame reject";
    thread->terminate();
	game->quickGame = false;
    ui->progressBar->setValue(0);
	game->settings->setValue("shuffling/random",ui->checkBox->checkState()==Qt::Checked?1:0);
	game->settings->setValue("shuffling/seed",ui->lineEdit->text());
	QDialog::reject();
}

void QuickGameDialog::on_pushButton_clicked()
{
	//this heavy duty ends if the window is closed, or it finishes
	//communication is via progress
	//force quit is by disbling the progressbar
	qDebug() << "quickGame start";
	thread->start();
}

void QuickGameDialog::on_checkBox_stateChanged(int state)
{
	ui->lineEdit->setEnabled(state==Qt::Unchecked);
	ui->lineEdit->setVisible(state==Qt::Unchecked);
	ui->label_5->setEnabled(state==Qt::Unchecked);
	ui->label_5->setVisible(state==Qt::Unchecked);
}

void QuickGameDialog::on_pushButton_2_clicked()
{
	game->resetMoney();
	progress();
}

void QuickGameDialog::on_checkBox_2_stateChanged(int state)
{
    //do nothing, quickgamethread do everything
}
