#include "quickgamethread.h"

QuickGameThread::QuickGameThread(Game* g, Ui::QuickGameDialog *qui)
{
	game = g;
	ui = qui;
}

void QuickGameThread::run(){
    game->profiler->reset();
    if(ui->checkBox->checkState()==Qt::Checked){
		game->rg.setSeed(-1);
    }else{
		game->rg.setSeed(ui->lineEdit->text().toInt());
    }
    ui->progressBar->setMaximum(ui->spinBox->value());
    for(int i=0;i<ui->spinBox->value();i++){
		game->profiler->start("game");
        game->profiler->start("game - prepare");
        if(ui->checkBox_2->checkState()==Qt::Unchecked){
            game->stav.forhont = 2; //so the next in the new game is 0=front player
        }
		game->newGame();
		game->profiler->stop("game - after results");
        game->profiler->start("game - update ui");
        if(ui->spinBox->value() < 100000 || i%100==0)
            emit progress(i+1);
		game->profiler->stop("game - update ui");
        game->profiler->stop("game");
	}
	QMap<QString,qreal> map = game->profiler->totals;
	QMapIterator<QString, qreal> i(map);
	while (i.hasNext()) {
		 i.next();
		 qDebug() << i.key() << ": " << i.value();
     }
}
