#ifndef RANDOMGENERATORIPSC_CPP
#define RANDOMGENERATORIPSC_CPP

#include<QDateTime>
#include<QDebug>
#include "randomgeneratoripsc.h"

RandomGeneratorIPSC::RandomGeneratorIPSC(int seed){
	int32_t ipsc_random_table_pom[GENERATOR_DEG] = {
		-1726662223,   379960547,  1735697613,  1040273694,  1313901226,  1627687941,
		-179304937, -2073333483,  1780058412, -1989503057,  -615974602,   344556628,
		 939512070, -1249116260,  1507946756,  -812545463,   154635395,  1388815473,
	   -1926676823,   525320961, -1009028674,   968117788,  -123449607,  1284210865,
		 435012392, -2017506339,  -911064859,  -370259173,  1132637927,  1398500161,
		-205601318};
	for(int i=0;i<GENERATOR_DEG;i++)
		this->ipsc_random_table[i] = ipsc_random_table_pom[i];
	front_pointer = 3;
	rear_pointer = 0;
	setSeed(seed);
}

RandomGeneratorIPSC::~RandomGeneratorIPSC(){
}

void RandomGeneratorIPSC::setSeed(int seed){
  int32_t i, dst=0, kc=GENERATOR_DEG, word, hi, lo;
  if(seed==-1)
    word = ipsc_random_table[0] = QDateTime::currentDateTime().toTime_t();
  else
    word = ipsc_random_table[0] = (seed==0) ? 1 : seed;
  for (i = 1; i < kc; ++i) {
    hi = word / 127773, lo = word % 127773;
    word = 16807 * lo - 2836 * hi;
    if (word < 0) word += 2147483647;
    ipsc_random_table[++dst] = word;
  }
  front_pointer=3, rear_pointer=0;
  kc *= 10;
  while (--kc >= 0) this->rand();
}

int RandomGeneratorIPSC::rand(int max){
  int32_t result;
  ipsc_random_table[ front_pointer ] += ipsc_random_table[ rear_pointer ];
  result = ( ipsc_random_table[ front_pointer ] >> 1 ) & 0x7fffffff;
  front_pointer++, rear_pointer++;
  if (front_pointer >= GENERATOR_DEG) front_pointer = 0;
  if (rear_pointer >= GENERATOR_DEG) rear_pointer = 0;
  return result % max;
}

#endif
