#ifndef RANDOMGENERATORIPSC_H
#define RANDOMGENERATORIPSC_H

/**
  *
  * @class RandomGeneratorIPSC
  *
  * @author Mirelon
  * Generates random numbers. Algorithm is the standard glibc. Source: IPSC archive 2007.
  *
*/

#include <climits>
#define GENERATOR_DEG 31

class RandomGeneratorIPSC{
  public:
    RandomGeneratorIPSC(int seed=-1);
    ~RandomGeneratorIPSC();
    void setSeed(int seed=-1);
    int rand(int max = INT_MAX);
    
    int32_t ipsc_random_table[GENERATOR_DEG];
    int front_pointer;
    int rear_pointer;
};


#endif
