#include <QtCore/QString>
#include <QtTest/QtTest>

#include "../../players/tromfchooser.h"
#include "../../randomgeneratoripsc.h"

#define NUM_TEST_VYSKYTY 1000000

class TestTromfChooser : public QObject
{
    Q_OBJECT

public:
    TestTromfChooser();

private Q_SLOTS:
    void initTestCase();
    void cleanupTestCase();
    void vyskytRozdani();
};

TestTromfChooser::TestTromfChooser()
{
}

void TestTromfChooser::initTestCase()
{
}

void TestTromfChooser::cleanupTestCase()
{
}

void TestTromfChooser::vyskytRozdani()
{
    QList<int> deck;
    QList<int> hand;

    RandomGeneratorIPSC rg;
    TromfChooser tc;
    tc.init();

    for(int i=0;i<NUM_TEST_VYSKYTY;i++){
        deck.clear();
        for(int j=0;j<32;j++){
            deck.push_back(j);
        }
        int swapCount = 1000+rg.rand(1000);
        for(int j=0;j<swapCount;j++)
            deck.swap(rg.rand(32),rg.rand(32));
        hand.clear();
        for(int j=0;j<7;j++)
            hand.push_back(deck[j]);

        tc.setHand(hand);
        int tromf = tc.chooseTromf();
        if(i%10000==0){
            qDebug() << i << "/" << NUM_TEST_VYSKYTY << "; hand=" << hand << " tromf=" << tromf;
        }
        QVERIFY(hand.contains(tromf));
    }
    qDebug() << "All" << NUM_TEST_VYSKYTY << "passed";

}

QTEST_APPLESS_MAIN(TestTromfChooser);

#include "tst_testtromfchooser.moc"
