/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.shape;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.shape.mxITextShape;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxCurve;
import com.mxgraph.util.mxLine;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.text.Bidi;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class mxCurveLabelShape
implements mxITextShape {
    protected String lastValue;
    protected Font lastFont;
    protected List<mxPoint> lastPoints;
    protected mxCurve curve;
    protected mxCellState state;
    protected LabelGlyphCache[] labelGlyphs;
    protected double labelSize;
    protected mxRectangle labelBounds;
    protected LabelPosition labelPosition = new LabelPosition();
    public static double LABEL_BUFFER = 30.0;
    public static double CURVE_TEXT_STRETCH_FACTOR = 20.0;
    public static mxRectangle INVALID_GLYPH_BOUNDS = new mxRectangle(0.0, 0.0, 0.0, 0.0);
    public int centerVisibleIndex = 0;
    public static Object FONT_FRACTIONALMETRICS = RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT;
    public GlyphVector[] rtlGlyphVectors;
    public static FontRenderContext frc = new FontRenderContext(null, false, false);
    protected boolean rotationEnabled = true;

    public mxCurveLabelShape(mxCellState mxCellState2, mxCurve mxCurve2) {
        this.state = mxCellState2;
        this.curve = mxCurve2;
    }

    public boolean getRotationEnabled() {
        return this.rotationEnabled;
    }

    public void setRotationEnabled(boolean bl) {
        this.rotationEnabled = bl;
    }

    @Override
    public void paintShape(mxGraphics2DCanvas mxGraphics2DCanvas2, String string, mxCellState mxCellState2, Map<String, Object> map) {
        Rectangle rectangle = mxCellState2.getLabelBounds().getRectangle();
        Graphics2D graphics2D = mxGraphics2DCanvas2.getGraphics();
        if (this.labelGlyphs == null) {
            this.updateLabelBounds(string, map);
        }
        if (this.labelGlyphs != null && (graphics2D.getClipBounds() == null || graphics2D.getClipBounds().intersects(rectangle))) {
            float f = mxUtils.getFloat(map, mxConstants.STYLE_OPACITY, 100.0f);
            Graphics2D graphics2D2 = graphics2D;
            graphics2D = mxGraphics2DCanvas2.createTemporaryGraphics(map, f, mxCellState2);
            Font font = mxUtils.getFont(map, mxGraphics2DCanvas2.getScale());
            graphics2D.setFont(font);
            Color color = mxUtils.getColor(map, mxConstants.STYLE_FONTCOLOR, Color.black);
            graphics2D.setColor(color);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, FONT_FRACTIONALMETRICS);
            for (int i = 0; i < this.labelGlyphs.length; ++i) {
                mxLine mxLine2 = this.labelGlyphs[i].glyphGeometry;
                if (!this.labelGlyphs[i].visible || mxLine2 == null || mxLine2 == mxCurve.INVALID_POSITION) continue;
                mxPoint mxPoint2 = mxLine2.getEndPoint();
                double d = mxPoint2.getX();
                double d2 = Math.atan(mxPoint2.getY() / d);
                if (d < 0.0) {
                    d2 += Math.PI;
                }
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.translate(mxLine2.getX(), mxLine2.getY());
                graphics2D.rotate(d2);
                Shape shape = this.labelGlyphs[i].glyphShape;
                graphics2D.fill(shape);
                graphics2D.setTransform(affineTransform);
            }
            graphics2D.dispose();
            graphics2D = graphics2D2;
        }
    }

    public mxRectangle updateLabelBounds(String string, Map<String, Object> map) {
        Object object;
        double d = this.state.getView().getScale();
        Font font = mxUtils.getFont(map, d);
        FontMetrics fontMetrics = mxUtils.getFontMetrics(font);
        int n = 0;
        int n2 = 0;
        if (fontMetrics != null) {
            n = fontMetrics.getDescent();
            n2 = fontMetrics.getAscent();
        }
        if (this.labelGlyphs == null || !string.equals(this.lastValue)) {
            this.labelGlyphs = new LabelGlyphCache[string.length()];
        }
        if (!string.equals(this.lastValue) || !font.equals(this.lastFont)) {
            int n3;
            int n4;
            Object object2;
            char[] cArray = string.toCharArray();
            ArrayList<LabelGlyphCache> arrayList = new ArrayList<LabelGlyphCache>();
            boolean bl = Bidi.requiresBidi(cArray, 0, cArray.length);
            this.labelSize = 0.0;
            if (bl) {
                object2 = new Bidi(string, -2);
                n4 = ((Bidi)object2).getRunCount();
                if (this.rtlGlyphVectors == null || this.rtlGlyphVectors.length != n4) {
                    this.rtlGlyphVectors = new GlyphVector[n4];
                }
                for (n3 = 0; n3 < ((Bidi)object2).getRunCount(); ++n3) {
                    String string2 = string.substring(((Bidi)object2).getRunStart(n3), ((Bidi)object2).getRunLimit(n3));
                    this.rtlGlyphVectors[n3] = font.layoutGlyphVector(frc, string2.toCharArray(), 0, string2.length(), 1);
                }
                n3 = 0;
                for (GlyphVector object3 : this.rtlGlyphVectors) {
                    float mxRectangle3 = 0.0f;
                    for (int i = 0; i < object3.getNumGlyphs(); ++i) {
                        mxRectangle mxLine2;
                        Shape shape = object3.getGlyphOutline(i, -mxRectangle3, 0.0f);
                        object = new LabelGlyphCache();
                        arrayList.add((LabelGlyphCache)object);
                        ((LabelGlyphCache)object).glyphShape = shape;
                        ((LabelGlyphCache)object).labelGlyphBounds = mxLine2 = new mxRectangle(object3.getGlyphLogicalBounds(i).getBounds2D());
                        this.labelSize += mxLine2.getWidth();
                        mxRectangle3 = (float)((double)mxRectangle3 + mxLine2.getWidth());
                        ++n3;
                    }
                }
            } else {
                int n5;
                this.rtlGlyphVectors = null;
                object2 = BreakIterator.getCharacterInstance(Locale.getDefault());
                ((BreakIterator)object2).setText(string);
                for (n4 = 0; n4 < string.length(); n4 += n5) {
                    n3 = ((BreakIterator)object2).next();
                    n5 = 1;
                    if (n3 != -1) {
                        n5 = n3 - n4;
                    }
                    String string3 = string.substring(n4, n4 + n5);
                    LabelGlyphCache labelGlyphCache = new LabelGlyphCache();
                    arrayList.add(labelGlyphCache);
                    labelGlyphCache.glyph = string3;
                    GlyphVector d8 = font.createGlyphVector(frc, string3);
                    labelGlyphCache.glyphShape = d8.getOutline();
                    if (fontMetrics == null) {
                        mxRectangle mxRectangle2;
                        labelGlyphCache.labelGlyphBounds = mxRectangle2 = new mxRectangle(font.getStringBounds(string3, frc));
                        this.labelSize += mxRectangle2.getWidth();
                        continue;
                    }
                    double d2 = fontMetrics.stringWidth(string3);
                    labelGlyphCache.labelGlyphBounds = new mxRectangle(0.0, 0.0, d2, n2);
                    this.labelSize += d2;
                }
            }
            this.lastValue = string;
            this.lastFont = font;
            this.lastPoints = this.curve.getGuidePoints();
            this.labelGlyphs = arrayList.toArray(new LabelGlyphCache[arrayList.size()]);
        }
        this.labelPosition.startBuffer = LABEL_BUFFER * d;
        this.labelPosition.endBuffer = LABEL_BUFFER * d;
        this.calculationLabelPosition(map, string);
        if (this.curve.isLabelReversed()) {
            double d3 = this.labelPosition.startBuffer;
            this.labelPosition.startBuffer = this.labelPosition.endBuffer;
            this.labelPosition.endBuffer = d3;
        }
        double d4 = this.curve.getCurveLength(mxCurve.LABEL_CURVE);
        double d5 = this.labelPosition.startBuffer / d4;
        double d6 = 1.0 - this.labelPosition.endBuffer / d4;
        mxRectangle mxRectangle4 = null;
        this.centerVisibleIndex = 0;
        double d7 = 0.0;
        double d3 = 0.3;
        double d8 = 0.5;
        object = null;
        for (int i = 0; i < this.labelGlyphs.length; ++i) {
            int n3;
            double d9;
            double d10;
            if (d5 > d6) {
                this.labelGlyphs[i].visible = false;
                continue;
            }
            Object object2 = object;
            if (d7 > d3 || object == null) {
                object2 = this.curve.getCurveParallel(mxCurve.LABEL_CURVE, d5);
                d7 = 0.0;
                object = null;
            }
            this.labelGlyphs[i].glyphGeometry = object2;
            if (object2 == mxCurve.INVALID_POSITION) continue;
            double d11 = this.labelGlyphs[i].labelGlyphBounds.getWidth();
            double d12 = this.labelGlyphs[i].labelGlyphBounds.getHeight();
            double d13 = ((mxLine)object2).getEndPoint().getX();
            double d14 = ((mxLine)object2).getEndPoint().getY();
            double d15 = d10 = ((mxPoint)object2).getX() - (double)n * d14;
            double d16 = d10;
            double d17 = d9 = ((mxPoint)object2).getY() + (double)n * d13;
            double d18 = d9;
            double d19 = d10 + (d12 + (double)n) * d14;
            double d20 = d9 - (d12 + (double)n) * d13;
            d15 = Math.min(d15, d19);
            d16 = Math.max(d16, d19);
            d17 = Math.min(d17, d20);
            d18 = Math.max(d18, d20);
            double d21 = d10 + d11 * d13;
            double d22 = d9 + d11 * d14;
            d15 = Math.min(d15, d21);
            d16 = Math.max(d16, d21);
            d17 = Math.min(d17, d22);
            d18 = Math.max(d18, d22);
            double d23 = d19 + d11 * d13;
            double d24 = d20 + d11 * d14;
            d15 = Math.min(d15, d23);
            d16 = Math.max(d16, d23);
            d17 = Math.min(d17, d24);
            d18 = Math.max(d18, d24);
            d15 -= 2.0 * d;
            d17 -= 2.0 * d;
            d16 += 2.0 * d;
            d18 += 2.0 * d;
            this.postprocessGlyph(this.curve, string, i, d5);
            double d25 = d5 + (this.labelGlyphs[i].labelGlyphBounds.getWidth() + this.labelPosition.defaultInterGlyphSpace) / d4;
            object = this.curve.getCurveParallel(mxCurve.LABEL_CURVE, d25);
            d5 = d25;
            mxPoint mxPoint2 = ((mxLine)object).getEndPoint();
            double d26 = mxPoint2.getX();
            double d27 = mxPoint2.getY();
            if (object != mxCurve.INVALID_POSITION && i + 1 < string.length()) {
                double d28 = Math.abs(d13 - d26);
                double d29 = Math.abs(d14 - d27);
                d7 = Math.sqrt(d28 * d28 + d29 * d29);
            }
            if (d7 > d3 && (n3 = Line2D.relativeCCW(0.0, 0.0, d13, d14, d26, d27)) == 1) {
                if (d7 > d8) {
                    d7 = d8;
                }
                double d30 = d7 * CURVE_TEXT_STRETCH_FACTOR / d4;
                d5 += d30;
                d6 += d30;
            }
            if (this.labelGlyphs[i].drawingBounds != null) {
                this.labelGlyphs[i].drawingBounds.setRect(d15, d17, d16 - d15, d18 - d17);
            } else {
                this.labelGlyphs[i].drawingBounds = new mxRectangle(d15, d17, d16 - d15, d18 - d17);
            }
            if (mxRectangle4 == null) {
                mxRectangle4 = (mxRectangle)this.labelGlyphs[i].drawingBounds.clone();
            } else {
                mxRectangle4.add(this.labelGlyphs[i].drawingBounds);
            }
            this.labelGlyphs[i].visible = true;
            ++this.centerVisibleIndex;
        }
        this.centerVisibleIndex /= 2;
        if (mxRectangle4 == null) {
            mxLine mxLine2 = this.curve.getCurveParallel(mxCurve.LABEL_CURVE, 0.5);
            mxRectangle4 = new mxRectangle(mxLine2.getX(), mxLine2.getY(), 1.0, 1.0);
        }
        this.labelBounds = mxRectangle4;
        return mxRectangle4;
    }

    protected void postprocessGlyph(mxCurve mxCurve2, String string, int n, double d) {
    }

    public boolean intersectsRect(Rectangle rectangle) {
        if (this.labelBounds != null && !this.labelBounds.getRectangle().intersects(rectangle) || this.labelGlyphs == null) {
            return false;
        }
        for (int i = 0; i < this.labelGlyphs.length; ++i) {
            if (!this.labelGlyphs[i].visible || !rectangle.intersects(this.labelGlyphs[i].drawingBounds.getRectangle())) continue;
            return true;
        }
        return false;
    }

    protected void calculationLabelPosition(Map<String, Object> map, String string) {
        double d = this.curve.getCurveLength(mxCurve.LABEL_CURVE);
        double d2 = d - this.labelPosition.startBuffer - this.labelPosition.endBuffer;
        this.labelPosition.startBuffer = Math.max(this.labelPosition.startBuffer, this.labelPosition.startBuffer + d2 / 2.0 - this.labelSize / 2.0);
        this.labelPosition.endBuffer = Math.max(this.labelPosition.endBuffer, this.labelPosition.endBuffer + d2 / 2.0 - this.labelSize / 2.0);
    }

    public mxCurve getCurve() {
        return this.curve;
    }

    public void setCurve(mxCurve mxCurve2) {
        this.curve = mxCurve2;
    }

    public mxRectangle getLabelBounds() {
        return this.labelBounds;
    }

    public mxRectangle getCenterVisiblePosition() {
        return this.labelGlyphs[this.centerVisibleIndex].drawingBounds;
    }

    public class LabelPosition {
        public double startBuffer = LABEL_BUFFER;
        public double endBuffer = LABEL_BUFFER;
        public double defaultInterGlyphSpace = 0.0;
    }

    public class LabelGlyphCache {
        public mxRectangle labelGlyphBounds;
        public mxRectangle drawingBounds;
        public String glyph;
        public mxLine glyphGeometry;
        public Shape glyphShape;
        public boolean visible;
    }
}

