/*
 * Decompiled with CFR 0.152.
 */
package Main;

import Main.Policko;
import Main.Read;
import Main.Vrchol;
import Main.Zarovnanie;
import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.canvas.mxSvgCanvas;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxDomUtils;
import com.mxgraph.util.mxUtils;
import com.mxgraph.util.mxXmlUtils;
import com.mxgraph.view.mxGraph;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JApplet;

public class Main
extends JApplet {
    public static ArrayList<Zarovnanie> zarovnania;
    public static ArrayList<Read> ready;
    public static String gen;
    public static Policko[] tabulkaVrcholov;
    public static Policko[] typVrcholov;
    public static int[][] maticaSusednosti;
    public static int[][] vybrate_hrany;
    public static mxGraph mxgraf;
    public static ArrayList<Vrchol> Vrcholy;
    public static double minVahaVrchola;
    public static int minVahaHrany;

    public static void nacitaj(String zarovnanie, String read, String g, int kvalita) throws FileNotFoundException, IOException, Exception {
        BufferedReader reader = new BufferedReader(new FileReader(zarovnanie));
        String line = reader.readLine();
        int preskoc = 5;
        while (line != null) {
            while (preskoc > 0) {
                --preskoc;
                line = reader.readLine();
            }
            String[] riadok = line.split("\t");
            if (riadok.length != 21) {
                throw new Exception("Riadok nie je vo form\u00e1te PSL!!!");
            }
            if (Integer.valueOf(riadok[0]) >= kvalita && Integer.valueOf(riadok[10]) == 101) {
                String[] v = riadok[18].split(",");
                String[] qs = riadok[19].split(",");
                String[] ts = riadok[20].split(",");
                int[] vv = new int[Integer.valueOf(riadok[17]).intValue()];
                int[] qq = new int[Integer.valueOf(riadok[17]).intValue()];
                int[] qe = new int[Integer.valueOf(riadok[17]).intValue()];
                int[] tt = new int[Integer.valueOf(riadok[17]).intValue()];
                int[] te = new int[Integer.valueOf(riadok[17]).intValue()];
                for (int i = 0; i < v.length; ++i) {
                    vv[i] = Integer.valueOf(v[i]);
                    qq[i] = Integer.valueOf(qs[i]);
                    qe[i] = vv[i] + qq[i];
                    tt[i] = Integer.valueOf(ts[i]);
                    te[i] = vv[i] + tt[i];
                }
                Zarovnanie z = new Zarovnanie(riadok[9], Integer.valueOf(riadok[0]), riadok[8], vv, qq, qe, tt, te);
                zarovnania.add(z);
            }
            line = reader.readLine();
        }
        reader.close();
        reader = new BufferedReader(new FileReader(read));
        String meno = reader.readLine();
        String sekvencia = reader.readLine();
        while (meno != null && sekvencia != null) {
            if (!"".equals(meno) && !"".equals(sekvencia)) {
                Read r = new Read(meno.substring(1, meno.length()), sekvencia);
                ready.add(r);
            }
            meno = reader.readLine();
            sekvencia = reader.readLine();
        }
        reader.close();
        reader = new BufferedReader(new FileReader(g));
        line = reader.readLine();
        line = "";
        while (line != null) {
            gen = gen + line;
            line = reader.readLine();
        }
        reader.close();
    }

    public static String zmenOrientaciu(String r) {
        String vysledok = "";
        block7: for (int i = 0; i < r.length(); ++i) {
            switch (r.charAt(i)) {
                case 'A': {
                    vysledok = "T" + vysledok;
                    continue block7;
                }
                case 'C': {
                    vysledok = "G" + vysledok;
                    continue block7;
                }
                case 'G': {
                    vysledok = "C" + vysledok;
                    continue block7;
                }
                case 'T': {
                    vysledok = "A" + vysledok;
                    continue block7;
                }
                case 'N': {
                    vysledok = "N" + vysledok;
                }
            }
        }
        return vysledok;
    }

    public static String najdiSekvenciuReadu(Zarovnanie z) {
        String result = "";
        for (Read r : ready) {
            if (!r.meno.equals(z.meno)) continue;
            result = r.sekvencia;
        }
        result = result.substring(z.qstarts[0], z.qends[0]);
        if (z.vlakno.equals("-")) {
            result = Main.zmenOrientaciu(result);
        }
        return result;
    }

    public static String najdiSekvenciuReferencie(Zarovnanie z) {
        String result = "";
        int zaciatok = Main.vratZaciatokIntervalu(z);
        int koniec = Main.vratKoniecIntervalu(z);
        result = gen.substring(zaciatok, koniec);
        return result;
    }

    public static void pridajVrcholyVariant() {
        for (Zarovnanie i : zarovnania) {
            if (i.tstarts.length != 1) continue;
            String si = Main.najdiSekvenciuReadu(i);
            String gi = Main.najdiSekvenciuReferencie(i);
            int pozicia_i = 0;
            String zmena_i = "";
            for (int k = 0; k < 101; ++k) {
                if (k >= si.length() || k >= gi.length() || si.substring(k, k + 1).equals(gi.substring(k, k + 1))) continue;
                pozicia_i = k + i.tstarts[0];
                zmena_i = si.substring(k, k + 1);
                tabulkaVrcholov[pozicia_i].zmen(zmena_i);
                zmena_i = "";
                pozicia_i = 0;
            }
        }
    }

    private static void pridajVrcholyReferencie(Zarovnanie i) {
        if (i.tstarts.length == 1) {
            String si = Main.najdiSekvenciuReadu(i);
            String gi = Main.najdiSekvenciuReferencie(i);
            int pozicia_i = 0;
            String zmena_i = "";
            for (int k = 0; k < 101; ++k) {
                if (k >= si.length() || k >= gi.length()) continue;
                pozicia_i = k + i.tstarts[0];
                zmena_i = si.substring(k, k + 1);
                String referencia = gi.substring(k, k + 1);
                int suma = tabulkaVrcholov[pozicia_i].scitaj(zmena_i);
                if (!zmena_i.equals(referencia) || suma <= 0) continue;
                tabulkaVrcholov[pozicia_i].zmen(zmena_i);
                typVrcholov[pozicia_i].zmen(zmena_i);
                zmena_i = "";
                pozicia_i = 0;
            }
        }
    }

    public static Zarovnanie najdiPar(Zarovnanie i) {
        Zarovnanie result = null;
        int c = Integer.valueOf(i.meno.substring(i.meno.length() - 1)) % 2 + 1;
        String meno = i.meno.substring(0, i.meno.length() - 1) + String.valueOf(c);
        for (Zarovnanie j : zarovnania) {
            if (!j.meno.equals(meno)) continue;
            result = j;
        }
        return result;
    }

    public static int indexHrany(String zmena, int pozicia) {
        int result = 5 * pozicia;
        switch (zmena.charAt(0)) {
            case 'A': {
                result += 0;
                break;
            }
            case 'C': {
                ++result;
                break;
            }
            case 'G': {
                result += 2;
                break;
            }
            case 'T': {
                result += 3;
                break;
            }
            case 'N': {
                result += 4;
                break;
            }
            default: {
                result += 4;
            }
        }
        return result;
    }

    public static int vratZaciatokIntervalu(Zarovnanie i) {
        int result = 0;
        result = i.tstarts[0];
        return result;
    }

    public static int vratKoniecIntervalu(Zarovnanie i) {
        int result = 0;
        result = i.tends[0];
        return result;
    }

    public static void vytvorHrany(Zarovnanie i, Zarovnanie j) {
        if (i.nespracovany) {
            ArrayList<Integer> kandidati = new ArrayList<Integer>();
            String si = Main.najdiSekvenciuReadu(i);
            int pozicia_i = 0;
            String zmena_i = "";
            for (int k = 0; k < 101; ++k) {
                if (k >= si.length() || tabulkaVrcholov[pozicia_i = k + i.tstarts[0]].pocet(zmena_i = si.substring(k, k + 1)) <= 0) continue;
                int index = Main.indexHrany(zmena_i, pozicia_i);
                kandidati.add(index);
            }
            if (j != null && j.nespracovany) {
                String sj = Main.najdiSekvenciuReadu(j);
                int pozicia_j = 0;
                String zmena_j = "";
                for (int k = 0; k < 101; ++k) {
                    if (k >= sj.length() || tabulkaVrcholov[pozicia_j = k + j.tstarts[0]].pocet(zmena_j = sj.substring(k, k + 1)) <= 0) continue;
                    int index = Main.indexHrany(zmena_j, pozicia_j);
                    kandidati.add(index);
                }
                j.nespracovany = false;
            }
            for (Integer k : kandidati) {
                for (Integer l : kandidati) {
                    Main.maticaSusednosti[k.intValue()][l.intValue()] = maticaSusednosti[k][l] + 1;
                }
            }
            i.nespracovany = false;
        }
    }

    public static void spracuj() throws Exception {
        Main.ZapisDoSuboru("pridaj vrcholy");
        Main.pridajVrcholyVariant();
        Main.ZapisDoSuboru("pridaj hrany");
        for (Zarovnanie i : zarovnania) {
            if (!i.nespracovany || i.tstarts.length != 1) continue;
            Main.ZapisDoSuboru("pridaj referenciu");
            Main.pridajVrcholyReferencie(i);
            Zarovnanie j = Main.najdiPar(i);
            if (j != null && j.nespracovany && j.tstarts.length == 1) {
                Main.pridajVrcholyReferencie(j);
            }
            Main.vytvorHrany(i, j);
        }
    }

    public static String spocitaj() {
        int i;
        int max = 0;
        for (int i2 = 0; i2 < gen.length() * 5; ++i2) {
            for (int j = 0; j < gen.length() * 5; ++j) {
                if (maticaSusednosti[i2][j] <= max) continue;
                max = maticaSusednosti[i2][j];
            }
        }
        int[] pocty = new int[max + 2];
        for (i = 0; i < pocty.length; ++i) {
            pocty[i] = 0;
        }
        for (i = 0; i < gen.length() * 5; ++i) {
            for (int j = 0; j < gen.length() * 5; ++j) {
                int n = maticaSusednosti[i][j];
                pocty[n] = pocty[n] + 1;
            }
        }
        String po = "";
        for (int i3 = 0; i3 < pocty.length; ++i3) {
            po = po + " " + Integer.toString(pocty[i3]);
        }
        return po;
    }

    public static void nakresliGraf() throws IOException {
        mxSvgCanvas canvas = (mxSvgCanvas)mxCellRenderer.drawCells(mxgraf, null, 1.0, null, new mxCellRenderer.CanvasFactory(){

            @Override
            public mxICanvas createCanvas(int width, int height) {
                mxSvgCanvas canvas = new mxSvgCanvas(mxDomUtils.createSvgDocument(width, height));
                canvas.setEmbedded(true);
                return canvas;
            }
        });
        mxUtils.writeFile(mxXmlUtils.getXml(canvas.getDocument()), "graf.svg");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void spravGraf() {
        Object parent = mxgraf.getDefaultParent();
        mxgraf.getModel().beginUpdate();
        ArrayList<Object> nodes = new ArrayList<Object>();
        int x = 100;
        int staraPozicia = 0;
        try {
            for (int i = 0; i < Vrcholy.size(); ++i) {
                Object node;
                if (staraPozicia != Main.Vrcholy.get((int)i).pozicia) {
                    staraPozicia = Main.Vrcholy.get((int)i).pozicia;
                    x += 100;
                }
                int y = 0;
                switch (Main.Vrcholy.get((int)i).zmena.charAt(0)) {
                    case 'A': {
                        y = 40;
                        break;
                    }
                    case 'C': {
                        y = 240;
                        break;
                    }
                    case 'G': {
                        y = 440;
                        break;
                    }
                    case 'T': {
                        y = 640;
                        break;
                    }
                    case 'N': {
                        y = 840;
                        break;
                    }
                    default: {
                        y = 1040;
                    }
                }
                if (Main.Vrcholy.get((int)i).referencia) {
                    node = mxgraf.insertVertex(parent, null, Main.Vrcholy.get((int)i).zmena + " na: " + Integer.toString(Main.Vrcholy.get((int)i).pozicia) + "\n" + Integer.toString(Main.Vrcholy.get((int)i).vaha), x, y, 80.0, 30.0, "portConstraint=north;fillColor=yellow;");
                    nodes.add(node);
                    continue;
                }
                node = mxgraf.insertVertex(parent, null, Main.Vrcholy.get((int)i).zmena + " na: " + Integer.toString(Main.Vrcholy.get((int)i).pozicia) + "\n" + Integer.toString(Main.Vrcholy.get((int)i).vaha), x, y, 80.0, 30.0, "portConstraint=north;fillColor=cyan;");
                nodes.add(node);
            }
            int n = Vrcholy.size();
            for (int i = 0; i < n; ++i) {
                int m = Main.Vrcholy.get((int)i).predchodcovia.size();
                for (int j = 0; j < m; ++j) {
                    int index = Main.Vrcholy.get((int)i).predchodcovia.get(j);
                    String farba = "";
                    if (j >= Main.Vrcholy.get((int)i).vybraty_predchodcovia.size() || index != Main.Vrcholy.get((int)i).vybraty_predchodcovia.get(j)) continue;
                    farba = "strokeColor=red;strokeWidth=3;";
                    if (Main.Vrcholy.get((int)i).zmena.equals(Main.Vrcholy.get((int)index).zmena)) {
                        mxgraf.insertEdge(parent, "", "", nodes.get(index), nodes.get(i), "rounded=2;edgeStyle=orthogonalEdgeStyle;" + farba);
                        continue;
                    }
                    mxgraf.insertEdge(parent, "", "", nodes.get(index), nodes.get(i), farba);
                }
            }
        }
        finally {
            mxgraf.getModel().endUpdate();
        }
    }

    public static void spravMaticuSusednosti2(int minVahaVrchola, int minVahaHrany) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter("matica.txt"));
        for (int i = 0; i < gen.length() * 5; ++i) {
            int pozicia_i = i / 5;
            int baza_i = i % 5;
            int vaha_i = 0;
            String zmena_i = "";
            switch (baza_i) {
                case 0: {
                    if (Main.tabulkaVrcholov[pozicia_i].A <= 0) break;
                    vaha_i = Main.tabulkaVrcholov[pozicia_i].A;
                    zmena_i = "A";
                    break;
                }
                case 1: {
                    if (Main.tabulkaVrcholov[pozicia_i].C <= 0) break;
                    vaha_i = Main.tabulkaVrcholov[pozicia_i].C;
                    zmena_i = "C";
                    break;
                }
                case 2: {
                    if (Main.tabulkaVrcholov[pozicia_i].G <= 0) break;
                    vaha_i = Main.tabulkaVrcholov[pozicia_i].G;
                    zmena_i = "G";
                    break;
                }
                case 3: {
                    if (Main.tabulkaVrcholov[pozicia_i].T <= 0) break;
                    vaha_i = Main.tabulkaVrcholov[pozicia_i].T;
                    zmena_i = "T";
                    break;
                }
                case 4: {
                    if (Main.tabulkaVrcholov[pozicia_i].N <= 0) break;
                    vaha_i = Main.tabulkaVrcholov[pozicia_i].N;
                    zmena_i = "N";
                    break;
                }
                default: {
                    zmena_i = "???";
                }
            }
            if (vaha_i <= minVahaVrchola) continue;
            String meno = "baza " + zmena_i + " na pozicii: " + Integer.toString(pozicia_i) + " s vahou " + Integer.toString(vaha_i) + "| ";
            writer.write(meno);
            for (int j = 0; j < gen.length() * 5; ++j) {
                int pozicia_j = j / 5;
                int baza_j = j % 5;
                int vaha_j = 0;
                String zmena_j = "";
                switch (baza_j) {
                    case 0: {
                        if (Main.tabulkaVrcholov[pozicia_j].A <= 0) break;
                        vaha_j = Main.tabulkaVrcholov[pozicia_j].A;
                        zmena_j = "A";
                        break;
                    }
                    case 1: {
                        if (Main.tabulkaVrcholov[pozicia_j].C <= 0) break;
                        vaha_j = Main.tabulkaVrcholov[pozicia_j].C;
                        zmena_j = "C";
                        break;
                    }
                    case 2: {
                        if (Main.tabulkaVrcholov[pozicia_j].G <= 0) break;
                        vaha_j = Main.tabulkaVrcholov[pozicia_j].G;
                        zmena_j = "G";
                        break;
                    }
                    case 3: {
                        if (Main.tabulkaVrcholov[pozicia_j].T <= 0) break;
                        vaha_j = Main.tabulkaVrcholov[pozicia_j].T;
                        zmena_j = "T";
                        break;
                    }
                    case 4: {
                        if (Main.tabulkaVrcholov[pozicia_j].N <= 0) break;
                        vaha_j = Main.tabulkaVrcholov[pozicia_j].N;
                        zmena_j = "N";
                        break;
                    }
                    default: {
                        zmena_j = "???";
                    }
                }
                if (vaha_j <= minVahaVrchola) continue;
                int vahaHrany = maticaSusednosti[i][j];
                if (vahaHrany > minVahaHrany && pozicia_i <= pozicia_j) {
                    String zapis = "";
                    zapis = " " + Integer.toString(vahaHrany) + " ";
                    writer.write(zapis);
                    continue;
                }
                writer.write("0 ");
            }
            writer.write("\n");
        }
        writer.flush();
        writer.close();
    }

    public static void filtrujGraf(double minVahaVrchola, int minVahaHrany) throws IOException {
        int i;
        BufferedWriter writer = new BufferedWriter(new FileWriter("linear.txt"));
        for (i = 0; i < gen.length() * 5; ++i) {
            int pozicia_i = i / 5;
            int baza_i = i % 5;
            int vaha_i = 0;
            boolean referencia_i = false;
            String zmena_i = "";
            switch (baza_i) {
                case 0: {
                    if (Main.tabulkaVrcholov[pozicia_i].A <= 0) break;
                    vaha_i = Main.tabulkaVrcholov[pozicia_i].A;
                    zmena_i = "A";
                    if (Main.typVrcholov[pozicia_i].A <= 0) break;
                    referencia_i = true;
                    break;
                }
                case 1: {
                    if (Main.tabulkaVrcholov[pozicia_i].C <= 0) break;
                    vaha_i = Main.tabulkaVrcholov[pozicia_i].C;
                    zmena_i = "C";
                    if (Main.typVrcholov[pozicia_i].C <= 0) break;
                    referencia_i = true;
                    break;
                }
                case 2: {
                    if (Main.tabulkaVrcholov[pozicia_i].G <= 0) break;
                    vaha_i = Main.tabulkaVrcholov[pozicia_i].G;
                    zmena_i = "G";
                    if (Main.typVrcholov[pozicia_i].G <= 0) break;
                    referencia_i = true;
                    break;
                }
                case 3: {
                    if (Main.tabulkaVrcholov[pozicia_i].T <= 0) break;
                    vaha_i = Main.tabulkaVrcholov[pozicia_i].T;
                    zmena_i = "T";
                    if (Main.typVrcholov[pozicia_i].T <= 0) break;
                    referencia_i = true;
                    break;
                }
                case 4: {
                    if (Main.tabulkaVrcholov[pozicia_i].N <= 0) break;
                    vaha_i = Main.tabulkaVrcholov[pozicia_i].N;
                    zmena_i = "N";
                    if (Main.typVrcholov[pozicia_i].N <= 0) break;
                    referencia_i = true;
                    break;
                }
                default: {
                    zmena_i = "N";
                }
            }
            boolean varianta = tabulkaVrcholov[pozicia_i].varianta(zmena_i, minVahaVrchola);
            if ((!referencia_i || !varianta) && (!((double)vaha_i > minVahaVrchola) || (!referencia_i || !varianta) && referencia_i)) continue;
            Vrcholy.add(new Vrchol(zmena_i, pozicia_i, vaha_i, i, referencia_i));
            for (int j = 0; j < gen.length() * 5; ++j) {
                int pozicia_j = j / 5;
                int baza_j = j % 5;
                int vaha_j = 0;
                String zmena_j = "";
                boolean referencia_j = false;
                switch (baza_j) {
                    case 0: {
                        if (Main.tabulkaVrcholov[pozicia_j].A <= 0) break;
                        vaha_j = Main.tabulkaVrcholov[pozicia_j].A;
                        zmena_j = "A";
                        if (Main.typVrcholov[pozicia_j].A <= 0) break;
                        referencia_j = true;
                        break;
                    }
                    case 1: {
                        if (Main.tabulkaVrcholov[pozicia_j].C <= 0) break;
                        vaha_j = Main.tabulkaVrcholov[pozicia_j].C;
                        zmena_j = "C";
                        if (Main.typVrcholov[pozicia_j].C <= 0) break;
                        referencia_j = true;
                        break;
                    }
                    case 2: {
                        if (Main.tabulkaVrcholov[pozicia_j].G <= 0) break;
                        vaha_j = Main.tabulkaVrcholov[pozicia_j].G;
                        zmena_j = "G";
                        if (Main.typVrcholov[pozicia_j].G <= 0) break;
                        referencia_j = true;
                        break;
                    }
                    case 3: {
                        if (Main.tabulkaVrcholov[pozicia_j].T <= 0) break;
                        vaha_j = Main.tabulkaVrcholov[pozicia_j].T;
                        zmena_j = "T";
                        if (Main.typVrcholov[pozicia_j].T <= 0) break;
                        referencia_j = true;
                        break;
                    }
                    case 4: {
                        if (Main.tabulkaVrcholov[pozicia_j].N <= 0) break;
                        vaha_j = Main.tabulkaVrcholov[pozicia_j].N;
                        zmena_j = "N";
                        if (Main.typVrcholov[pozicia_j].N <= 0) break;
                        referencia_j = true;
                        break;
                    }
                    default: {
                        zmena_j = "???";
                    }
                }
                boolean varianta_j = tabulkaVrcholov[pozicia_j].varianta(zmena_j, minVahaVrchola);
                if ((!referencia_j || !varianta_j) && (!((double)vaha_j > minVahaVrchola) || (!referencia_j || !varianta_j) && referencia_j)) continue;
                int vahaHrany = maticaSusednosti[i][j];
                if (vahaHrany > minVahaHrany && pozicia_i <= pozicia_j) {
                    writer.write("1 ");
                    continue;
                }
                writer.write("0 ");
            }
            writer.write("\n");
        }
        writer.flush();
        writer.close();
        vybrate_hrany = new int[Vrcholy.size()][Vrcholy.size()];
        for (i = 0; i < Vrcholy.size(); ++i) {
            for (int j = 0; j < Vrcholy.size(); ++j) {
                Main.vybrate_hrany[i][j] = 0;
            }
        }
    }

    public static void ZapisDoSuboru(String text) throws IOException {
        FileWriter w = new FileWriter("vystup.txt");
        BufferedWriter bw = new BufferedWriter(w);
        bw.write(text + "\n");
        bw.flush();
        bw.close();
    }

    public static void predchodcoviaNasledovnici(int minVahaHrany) {
        int n = Vrcholy.size();
        for (int i = 0; i < n; ++i) {
            int vahaHrany;
            int ii;
            int jj;
            int j;
            for (j = i - 1; j >= 0; --j) {
                jj = Main.Vrcholy.get((int)j).index;
                ii = Main.Vrcholy.get((int)i).index;
                vahaHrany = maticaSusednosti[jj][ii];
                if (vahaHrany <= minVahaHrany) continue;
                Main.Vrcholy.get((int)i).predchodcovia.add(j);
            }
            for (j = i + 1; j < n; ++j) {
                ii = Main.Vrcholy.get((int)i).index;
                jj = Main.Vrcholy.get((int)j).index;
                vahaHrany = maticaSusednosti[ii][jj];
                if (vahaHrany <= minVahaHrany) continue;
                Main.Vrcholy.get((int)i).nasledovnici.add(j);
            }
        }
    }

    public static void redukujGraf() {
        int n = Vrcholy.size();
        for (int i = 0; i < n; ++i) {
            int m = Main.Vrcholy.get((int)i).predchodcovia.size();
            Main.Vrcholy.get((int)i).set_colors.add(i);
            for (int j = 0; j < m; ++j) {
                int predchodca = Main.Vrcholy.get((int)i).predchodcovia.get(j);
                if (Main.Vrcholy.get((int)i).set_colors.contains(predchodca)) continue;
                Main.Vrcholy.get((int)i).vybraty_predchodcovia.add(Main.Vrcholy.get((int)i).predchodcovia.get(j));
                Main.vybrate_hrany[Main.Vrcholy.get((int)i).predchodcovia.get((int)j).intValue()][i] = 1;
                Main.Vrcholy.get((int)i).set_colors.addAll(Main.Vrcholy.get((int)predchodca).set_colors);
            }
        }
    }

    public static void inicializuj(double minVrchol, int minHrana) {
        minVahaVrchola = minVrchol;
        minVahaHrany = minHrana;
        zarovnania = new ArrayList();
        ready = new ArrayList();
        gen = "";
        mxgraf = new mxGraph();
        Vrcholy = new ArrayList();
    }

    public static void inicializujPolia() {
        Policko p;
        int i;
        tabulkaVrcholov = new Policko[gen.length()];
        for (i = 0; i < gen.length(); ++i) {
            Main.tabulkaVrcholov[i] = p = new Policko();
        }
        typVrcholov = new Policko[gen.length()];
        for (i = 0; i < gen.length(); ++i) {
            Main.typVrcholov[i] = p = new Policko();
        }
        maticaSusednosti = new int[gen.length() * 5][gen.length() * 5];
        for (i = 0; i < gen.length() * 5; ++i) {
            for (int j = 0; j < gen.length() * 5; ++j) {
                Main.maticaSusednosti[i][j] = 0;
            }
        }
    }

    public static void demo1() {
        int j;
        int i;
        minVahaVrchola = 1200.0;
        minVahaHrany = 1200;
        zarovnania = new ArrayList();
        ready = new ArrayList();
        gen = "AAAAAAAAAA";
        mxgraf = new mxGraph();
        Vrcholy = new ArrayList();
        Vrcholy.add(new Vrchol("A", 0, 3000, 0, true));
        Vrcholy.add(new Vrchol("G", 0, 3000, 2, true));
        Vrcholy.add(new Vrchol("C", 1, 3000, 6, true));
        Vrcholy.add(new Vrchol("A", 2, 3000, 10, true));
        Vrcholy.add(new Vrchol("G", 2, 3000, 12, true));
        maticaSusednosti = new int[gen.length() * 5][gen.length() * 5];
        for (i = 0; i < gen.length() * 5; ++i) {
            for (j = 0; j < gen.length() * 5; ++j) {
                Main.maticaSusednosti[i][j] = 0;
            }
        }
        Main.maticaSusednosti[0][6] = 3000;
        Main.maticaSusednosti[0][10] = 3000;
        Main.maticaSusednosti[2][6] = 3000;
        Main.maticaSusednosti[2][10] = 3000;
        Main.maticaSusednosti[2][12] = 3000;
        Main.maticaSusednosti[6][10] = 3000;
        Main.maticaSusednosti[6][12] = 3000;
        vybrate_hrany = new int[Vrcholy.size()][Vrcholy.size()];
        for (i = 0; i < Vrcholy.size(); ++i) {
            for (j = 0; j < Vrcholy.size(); ++j) {
                Main.vybrate_hrany[i][j] = 0;
            }
        }
    }

    public static void spravMaticesusednosti() throws IOException {
        int i;
        int i2;
        int j;
        int i3;
        int[][] matica = new int[Vrcholy.size()][Vrcholy.size()];
        for (i3 = 0; i3 < Vrcholy.size(); ++i3) {
            for (int j2 = 0; j2 < Vrcholy.size(); ++j2) {
                matica[i3][j2] = 0;
            }
        }
        for (i3 = 0; i3 < Vrcholy.size(); ++i3) {
            int m = Main.Vrcholy.get((int)i3).predchodcovia.size();
            for (j = 0; j < m; ++j) {
                int index = Main.Vrcholy.get((int)i3).predchodcovia.get(j);
                matica[index][i3] = 1;
            }
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter("grafVariantov.txt"));
        for (i2 = 0; i2 < Vrcholy.size(); ++i2) {
            for (j = 0; j < Vrcholy.size(); ++j) {
                int vaha = matica[i2][j];
                if (vaha > 0) {
                    writer.write("1 ");
                    continue;
                }
                writer.write("0 ");
            }
            writer.write("\n");
        }
        writer.flush();
        writer.close();
        for (i2 = 0; i2 < Vrcholy.size(); ++i2) {
            for (j = 0; j < Vrcholy.size(); ++j) {
                matica[i2][j] = 0;
            }
        }
        int n = Vrcholy.size();
        for (i = 0; i < n; ++i) {
            int m = Main.Vrcholy.get((int)i).predchodcovia.size();
            for (int j3 = 0; j3 < m; ++j3) {
                int index = Main.Vrcholy.get((int)i).predchodcovia.get(j3);
                if (j3 >= Main.Vrcholy.get((int)i).vybraty_predchodcovia.size() || index != Main.Vrcholy.get((int)i).vybraty_predchodcovia.get(j3)) continue;
                matica[index][i] = 1;
            }
        }
        writer = new BufferedWriter(new FileWriter("redukovanyGrafVariantov.txt"));
        for (i = 0; i < Vrcholy.size(); ++i) {
            for (int j4 = 0; j4 < Vrcholy.size(); ++j4) {
                int vaha = matica[i][j4];
                if (vaha > 0) {
                    writer.write("1 ");
                    continue;
                }
                writer.write("0 ");
            }
            writer.write("\n");
        }
        writer.flush();
        writer.close();
    }

    public static void infoVrcholy() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter("infoVrcholy.txt"));
        for (int i = 0; i < Vrcholy.size(); ++i) {
            Vrchol v = Vrcholy.get(i);
            String riadok = Integer.toString(v.pozicia) + "\t" + v.zmena + "\t" + Boolean.toString(v.referencia) + "\t" + Integer.toString(v.vaha);
            writer.write(riadok);
            writer.write("\n");
        }
        writer.flush();
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nacitajGraf(String matica, String vr) throws FileNotFoundException, IOException {
        Vrcholy = new ArrayList();
        BufferedReader reader = new BufferedReader(new FileReader(vr));
        String line = reader.readLine();
        while (line != null) {
            String[] parametre = line.split("\t");
            Vrchol v = new Vrchol(parametre[1], Integer.valueOf(parametre[0]), Integer.valueOf(parametre[3]), 0, Boolean.valueOf(parametre[2]));
            Vrcholy.add(v);
            line = reader.readLine();
        }
        reader.close();
        mxgraf = new mxGraph();
        Object parent = mxgraf.getDefaultParent();
        mxgraf.getModel().beginUpdate();
        ArrayList<Object> nodes = new ArrayList<Object>();
        int x = 100;
        int staraPozicia = 0;
        try {
            for (int i = 0; i < Vrcholy.size(); ++i) {
                Object node;
                if (staraPozicia != Main.Vrcholy.get((int)i).pozicia) {
                    staraPozicia = Main.Vrcholy.get((int)i).pozicia;
                    x += 100;
                }
                int y = 0;
                switch (Main.Vrcholy.get((int)i).zmena.charAt(0)) {
                    case 'A': {
                        y = 40;
                        break;
                    }
                    case 'C': {
                        y = 240;
                        break;
                    }
                    case 'G': {
                        y = 440;
                        break;
                    }
                    case 'T': {
                        y = 640;
                        break;
                    }
                    case 'N': {
                        y = 840;
                        break;
                    }
                    default: {
                        y = 1040;
                    }
                }
                if (Main.Vrcholy.get((int)i).referencia) {
                    node = mxgraf.insertVertex(parent, null, Main.Vrcholy.get((int)i).zmena + " na: " + Integer.toString(Main.Vrcholy.get((int)i).pozicia) + "\n" + Integer.toString(Main.Vrcholy.get((int)i).vaha), x, y, 80.0, 30.0, "portConstraint=north;fillColor=yellow;");
                    nodes.add(node);
                    continue;
                }
                node = mxgraf.insertVertex(parent, null, Main.Vrcholy.get((int)i).zmena + " na: " + Integer.toString(Main.Vrcholy.get((int)i).pozicia) + "\n" + Integer.toString(Main.Vrcholy.get((int)i).vaha), x, y, 80.0, 30.0, "portConstraint=north;fillColor=cyan;");
                nodes.add(node);
            }
            reader = new BufferedReader(new FileReader(matica));
            line = reader.readLine();
            String[] farby = new String[]{"blue", "red", "black", "gray", "green", "yellow", "orange", "pink", "magenta", "darkGray"};
            int[] hrubky = new int[]{24, 20, 16, 12, 8, 4, 8, 12, 16, 20};
            for (int pocet = Integer.valueOf(line).intValue(); pocet > 0; --pocet) {
                int i;
                maticaSusednosti = new int[Vrcholy.size()][Vrcholy.size()];
                for (i = 0; i < Vrcholy.size(); ++i) {
                    for (int j = 0; j < Vrcholy.size(); ++j) {
                        Main.maticaSusednosti[i][j] = 0;
                    }
                }
                for (i = 0; i < Vrcholy.size(); ++i) {
                    line = reader.readLine();
                    String[] susedia = line.split("\t");
                    for (int j = 0; j < Vrcholy.size(); ++j) {
                        Main.maticaSusednosti[i][j] = Integer.valueOf(susedia[j]);
                    }
                }
                for (i = 0; i < Vrcholy.size(); ++i) {
                    for (int j = 0; j < Vrcholy.size(); ++j) {
                        if (maticaSusednosti[i][j] != 1) continue;
                        String farba = "strokeColor=".concat(farby[farby.length - pocet] + ";");
                        farba = farba.concat("strokeWidth=" + Integer.toString(hrubky[hrubky.length - pocet]) + ";startArrow=none;endArrow=none;");
                        if (Main.Vrcholy.get((int)i).zmena.equals(Main.Vrcholy.get((int)j).zmena)) {
                            mxgraf.insertEdge(parent, "", "", nodes.get(i), nodes.get(j), "curved=1;rounded=1;edgeStyle=orthogonalEdgeStyle;" + farba);
                            continue;
                        }
                        mxgraf.insertEdge(parent, "", "", nodes.get(i), nodes.get(j), farba);
                    }
                }
            }
            reader.close();
        }
        finally {
            mxgraf.getModel().endUpdate();
        }
    }

    public static void nakresliVarianty(String cesty, String info) throws FileNotFoundException, IOException {
        Main.nacitajGraf(cesty, info);
        Main.nakresliGraf();
    }

    public static void simuluj() throws IOException {
        Main.demo1();
        Main.predchodcoviaNasledovnici(minVahaHrany);
        Main.redukujGraf();
        Main.spravMaticesusednosti();
        Main.infoVrcholy();
        Main.spravGraf();
        Main.nakresliGraf();
    }

    public static void generujGrafy(int minVrchol, int minHrana) throws IOException, FileNotFoundException, Exception {
        Main.inicializuj(minVrchol, minHrana);
        Main.nacitaj("aln.psl", "selected-reads.fa", "fdh-dna.fa", 90);
        Main.inicializujPolia();
        Main.spracuj();
        Main.filtrujGraf(minVahaVrchola, minVahaHrany);
        Main.predchodcoviaNasledovnici(minVahaHrany);
        Main.redukujGraf();
        Main.spravMaticesusednosti();
        Main.infoVrcholy();
        Main.spravGraf();
        Main.nakresliGraf();
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, Exception {
        Main.nakresliVarianty(args[0], args[1]);
        System.out.print("Hotovo\n\n");
    }
}

