// Graph.h: interface for the CGraph class.
//
//////////////////////////////////////////////////////////////////////

#include "Edge.h"
#include "Route.h"

#if !defined(AFX_GRAPH_H__E35043F7_F5B1_4232_93D2_56E7B2200895__INCLUDED_)
#define AFX_GRAPH_H__E35043F7_F5B1_4232_93D2_56E7B2200895__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CGraph : public CObject  
{
public:
	void ClearEdgesState();
	void AddNodeToPos(int index,CNode* node);
	void CreateNodeArray(int length);
	void SetCapacity(int cap);
	float CountRouteCost(int RouteId);
	void AddRoute();
	int GetNodeState(int id);
	int GetRouteCount();
	void DecRouteDemand(int route,int dec);
	void IncRouteDemand(int route,int inc);
	int GetRouteDemand(int id);
	float ComputeEuclidianDistance(CPoint p1, CPoint p2);
	void UpdateEdgeValues();
	int GetCapacity();
	CRoute* GetRoute(int id);
	void MergeRoutesSS(int fr,int sr,int fn, int sn);
	void MergeRoutesFF(int fr,int sr,int fn,int sn);
	void MergeRoutesSF(int fr,int sr,int fn,int sn);
	void MergeRoutesFS(int fr,int sr, int fn, int sn);

	void MergeRoutes(int fr, int sr, int fn, int sn);
	

	void RoutesToEdges();
	CNode* GetNode(int index);
	void AddNodeToRouteTail(int route,CNode* node);
	int GetNodeDemand(int node);
	void SetRouteDemand(int route,int demand);
	void SetRouteCost(int route, int cost);
	void SetRouteState(int route,int state);
	void SetRouteId(int route,int id);
	void CreateRoutes(int count);
	float GetEdgeValue(int i, int j);
	int GetNodeCount();
	CString GetName();
	BOOL LoadFromFile(CString filename);
	CNode* getSlctNode();
	CNode* SelectNode(CPoint point);
	CRect getGraphRect();
	void Show(CDC* pDC);
	void addNodeTail(CNode* pNode);
	void Serialize(CArchive &ar);
	void UpdateGraphRect();
	CGraph();
	virtual ~CGraph();
	void CreateEdgeTable();

private:
	
	int m_nEdgeArrayLength;
	
	int m_nCapacity;
	CString m_sType;
	CString m_sComment;
	CString m_sName;
	CNode* m_pSlctNode;

	CRect m_GraphRect;
	int m_nNodeArrayLength; 
	CNode** m_pNodeArray;
	CEdge*** m_pEdgeArray;
	int m_nRouteArrayLength;
	CRoute** m_pRouteArray;
};

#endif // !defined(AFX_GRAPH_H__E35043F7_F5B1_4232_93D2_56E7B2200895__INCLUDED_)
