// InsertionAlgorithm.cpp: implementation of the CInsertionAlgorithm class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "VRP.h"
#include "InsertionAlgorithm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CInsertionAlgorithm::CInsertionAlgorithm()
{

}

CInsertionAlgorithm::CInsertionAlgorithm(CVRPDoc* doc) 
	:CAlgorithm(doc)
{

}

CInsertionAlgorithm::~CInsertionAlgorithm()
{

}

void CInsertionAlgorithm::CountNearestAddition(int RouteId)
{
	int demand;
	float cost;
	CRoute* route = m_pDoc->m_Graph->GetRoute(RouteId);
	CNode* node;

	for (int i=1; i < m_pDoc->m_Graph->GetNodeCount();i++) {
		node = m_pDoc->m_Graph->GetNode(i);
		node->SetInsertCost(-1);
		node->SetInsertIndex(-1);
		
		// check only unrouted nodes
		if (node->GetState() == 0) {
			demand = route->getDemand() + node->getDemand();
			if (demand <= m_pDoc->m_Graph->GetCapacity()) {
				// check all possibilieties to insert in route
				for (int j=1;j < route->getLength(); j++) {
					cost = m_pDoc->m_Graph->GetEdgeValue(route->GetNodeId(j-1),i); 
					// if it is first possible
					if (m_pDoc->m_Graph->GetNode(i)->GetInsertCost() == -1) {
						m_pDoc->m_Graph->GetNode(i)->SetInsertCost(cost);
						m_pDoc->m_Graph->GetNode(i)->SetInsertIndex(j);
					// if insertion is cheaper
					} else if (m_pDoc->m_Graph->GetNode(i)->GetInsertCost() >= cost) {
						m_pDoc->m_Graph->GetNode(i)->SetInsertCost(cost);
						m_pDoc->m_Graph->GetNode(i)->SetInsertIndex(j);
					};
				}
			}
		}
	}
}

void CInsertionAlgorithm::SolveAdditionBestSeq()
{
	m_pDoc->m_Graph->CreateRoutes(0);
	m_pDoc->m_Graph->UpdateEdgeValues();
	InitVariables();
	BOOL routed = AllRouted();
	
	int routeId = SetNewRoute();
	while (!routed) {
		CountNearestAddition(routeId);
		int nodeId = ChooseNodeToInsert();
		while (nodeId != -1) {
			InsertNodeToRoute(nodeId,routeId);
			CountNearestAddition(routeId);
			nodeId = ChooseNodeToInsert();
		};
		routed = AllRouted();
		if (!routed) {
			routeId = SetNewRoute();
		}
	};

	m_pDoc->UpdateAllViews(NULL);
}

void CInsertionAlgorithm::InitVariables()
{
	for (int i=0; i < m_pDoc->m_Graph->GetNodeCount(); i++) {
		m_pDoc->m_Graph->GetNode(i)->SetState(0);
	}
}

int CInsertionAlgorithm::SetNewRoute()
{
	m_pDoc->m_Graph->AddRoute();
	int RouteId = m_pDoc->m_Graph->GetRouteCount()-1;
	m_pDoc->m_Graph->AddNodeToRouteTail(RouteId,m_pDoc->m_Graph->GetNode(0));
	m_pDoc->m_Graph->AddNodeToRouteTail(RouteId,m_pDoc->m_Graph->GetNode(0));
	return RouteId;
}

int CInsertionAlgorithm::ChooseNodeToInsert()
{
	int result = -1;
	float min = -1;

	for (int i = 1 ; i < m_pDoc->m_Graph->GetNodeCount();i++) {
		// check only unrouted nodes and nodes wich can be inserted
		if ((m_pDoc->m_Graph->GetNodeState(i) == 0) && 
			(m_pDoc->m_Graph->GetNode(i)->GetInsertIndex() != -1)) {
			if (min == -1) {
				result = i;
				min = m_pDoc->m_Graph->GetNode(i)->GetInsertCost(); 
			} else if (min >= m_pDoc->m_Graph->GetNode(i)->GetInsertCost()) {
				result = i;
				min = m_pDoc->m_Graph->GetNode(i)->GetInsertCost();
			}
		}
	}
	return result;	
}

void CInsertionAlgorithm::InsertNodeToRoute(int NodeId,int RouteId)
{
	CNode* node = m_pDoc->m_Graph->GetNode(NodeId);

	m_pDoc->m_Graph->GetRoute(RouteId)->InsertNode(node->GetInsertIndex(),node);
	m_pDoc->m_Graph->IncRouteDemand(RouteId,node->getDemand());
	node->SetState(1);
	node->setRouteId(RouteId);
}

BOOL CInsertionAlgorithm::AllRouted()
{
	BOOL test = true;
	int count = 1;
	while ((test) && (count < m_pDoc->m_Graph->GetNodeCount())) {
		if (m_pDoc->m_Graph->GetNodeState(count) == 0) test = false;
		count++;
	}
	return test;
}

void CInsertionAlgorithm::SolveAdditionBestPar()
{
	m_pDoc->m_Graph->CreateRoutes(0);
	m_pDoc->m_Graph->UpdateEdgeValues();
	InitVariables();
	
	BOOL routed = AllRouted();
	
	while (!routed) {
		CountNearestAdditionParalel();
		int nodeId = ChooseNodeToInsertParalel();
		InsertNodeToRouteParalel(nodeId);
		routed = AllRouted();
	};
	m_pDoc->UpdateAllViews(NULL);
}

void CInsertionAlgorithm::CountNearestAdditionParalel()
{
	int demand;
	float cost;
	CNode* node;
	CRoute* route;

	for (int i=1; i < m_pDoc->m_Graph->GetNodeCount();i++) {
		node = m_pDoc->m_Graph->GetNode(i);
		node->SetInsertCost(m_pDoc->m_Graph->GetEdgeValue(0,i));
		node->SetInsertIndex(-1);
		node->SetInsertRouteId(-1); 
		
		for (int k=0;k < m_pDoc->m_Graph->GetRouteCount();k++) {
			route = m_pDoc->m_Graph->GetRoute(k);
			// check only unrouted nodes
			if (node->GetState() == 0) {
				demand = route->getDemand() + node->getDemand();
				if (demand <= m_pDoc->m_Graph->GetCapacity()) {
					// check all possibilieties to insert in route
					for (int j=1;j < route->getLength(); j++) {
						cost = m_pDoc->m_Graph->GetEdgeValue(route->GetNodeId(j-1),i); 
						// if it is first possible
						if (m_pDoc->m_Graph->GetNode(i)->GetInsertCost() == -1) {
							m_pDoc->m_Graph->GetNode(i)->SetInsertCost(cost);
							m_pDoc->m_Graph->GetNode(i)->SetInsertIndex(j);
							m_pDoc->m_Graph->GetNode(i)->SetInsertRouteId(k);
						// if insertion is cheaper
						} else if (m_pDoc->m_Graph->GetNode(i)->GetInsertCost() >= cost) {
							m_pDoc->m_Graph->GetNode(i)->SetInsertCost(cost);
							m_pDoc->m_Graph->GetNode(i)->SetInsertIndex(j);
							m_pDoc->m_Graph->GetNode(i)->SetInsertRouteId(k);
						};
					}
				}
			}
		}
	}
}

int CInsertionAlgorithm::ChooseNodeToInsertParalel()
{
	int result = -1;
	float min = -1;

	for (int i = 1 ; i < m_pDoc->m_Graph->GetNodeCount();i++) {
		// check only unrouted nodes and nodes wich can be inserted
		if (m_pDoc->m_Graph->GetNodeState(i) == 0)  {
			if (min == -1) {
				result = i;
				min = m_pDoc->m_Graph->GetNode(i)->GetInsertCost(); 
			} else if (min >= m_pDoc->m_Graph->GetNode(i)->GetInsertCost()) {
				result = i;
				min = m_pDoc->m_Graph->GetNode(i)->GetInsertCost();
			}
		}
	}
	return result;	
}

void CInsertionAlgorithm::InsertNodeToRouteParalel(int NodeId)
{
	CNode* node = m_pDoc->m_Graph->GetNode(NodeId);
	int RouteId;
	if (node->GetInsertRouteId() == -1) {
		RouteId = SetNewRoute();
		node->SetInsertIndex(1);
	}
	else RouteId = node->GetInsertRouteId();
	
	m_pDoc->m_Graph->GetRoute(RouteId)->InsertNode(node->GetInsertIndex(),node);
	m_pDoc->m_Graph->IncRouteDemand(RouteId,node->getDemand());
	node->SetState(1);
	node->setRouteId(RouteId);
	
}

void CInsertionAlgorithm::CountNearestInsertionParalel()
{
	int demand;
	float cost;
	CNode* node;
	CRoute* route;

	for (int i=1; i < m_pDoc->m_Graph->GetNodeCount();i++) {
		node = m_pDoc->m_Graph->GetNode(i);
		node->SetInsertCost(m_pDoc->m_Graph->GetEdgeValue(0,i));
		node->SetInsertIndex(-1);
		node->SetInsertRouteId(-1); 
		
		for (int k=0;k < m_pDoc->m_Graph->GetRouteCount();k++) {
			route = m_pDoc->m_Graph->GetRoute(k);
			// check only unrouted nodes
			if (node->GetState() == 0) {
				demand = route->getDemand() + node->getDemand();
				if (demand <= m_pDoc->m_Graph->GetCapacity()) {
					// check all possibilieties to insert in route
					for (int j=1;j < route->getLength(); j++) {
						cost = m_pDoc->m_Graph->GetEdgeValue(route->GetNodeId(j-1),i); 
						// if it is first possible
						if (m_pDoc->m_Graph->GetNode(i)->GetInsertCost() == -1) {
							m_pDoc->m_Graph->GetNode(i)->SetInsertCost(cost);
							m_pDoc->m_Graph->GetNode(i)->SetInsertIndex(j);
							m_pDoc->m_Graph->GetNode(i)->SetInsertRouteId(k);
						// if insertion is cheaper
						} else if (m_pDoc->m_Graph->GetNode(i)->GetInsertCost() >= cost) {
							m_pDoc->m_Graph->GetNode(i)->SetInsertCost(cost);
							m_pDoc->m_Graph->GetNode(i)->SetInsertIndex(j);
							m_pDoc->m_Graph->GetNode(i)->SetInsertRouteId(k);
						};
					}
				}
			}
		}
	}
}

void CInsertionAlgorithm::SolveAdditionNearSeq()
{
	m_pDoc->m_Graph->CreateRoutes(0);
	m_pDoc->m_Graph->UpdateEdgeValues();
	InitVariables();
	BOOL routed = AllRouted();
	
	int routeId = SetNewRoute();
	while (!routed) {
		CountNearestAddition(routeId);
		int nodeId = ChooseNearNodeToInsert();
		while (nodeId != -1) {
			InsertNodeToRoute(nodeId,routeId);
			CountNearestAddition(routeId);
			nodeId = ChooseNearNodeToInsert();
		};
		routed = AllRouted();
		if (!routed) {
			routeId = SetNewRoute();
		}
	};

	m_pDoc->UpdateAllViews(NULL);
}

int CInsertionAlgorithm::ChooseNearNodeToInsert()
{
	int result = -1;
	float min = -1;

	for (int i = 1 ; i < m_pDoc->m_Graph->GetNodeCount();i++) {
		// check only unrouted nodes and nodes wich can be inserted
		if ((m_pDoc->m_Graph->GetNodeState(i) == 0) && 
			(m_pDoc->m_Graph->GetNode(i)->GetInsertIndex() != -1)) {
			if (min == -1) {
				result = i;
				min = m_pDoc->m_Graph->GetEdgeValue(0,m_pDoc->m_Graph->GetNode(i)->getId()); 
			} else if (min >= m_pDoc->m_Graph->GetEdgeValue(0,m_pDoc->m_Graph->GetNode(i)->getId())) {
				result = i;
				min = m_pDoc->m_Graph->GetEdgeValue(0,m_pDoc->m_Graph->GetNode(i)->getId()); 
			}
		}
	}
	return result;	
}

void CInsertionAlgorithm::SolveAdditionNearPar()
{
	m_pDoc->m_Graph->CreateRoutes(0);
	m_pDoc->m_Graph->UpdateEdgeValues();
	InitVariables();
	
	BOOL routed = AllRouted();
	
	while (!routed) {
		CountNearestAdditionParalel();
		int nodeId = ChooseNearNodeToInsertParalel();
		InsertNodeToRouteParalel(nodeId);
		routed = AllRouted();
	};
	m_pDoc->UpdateAllViews(NULL);
}

int CInsertionAlgorithm::ChooseNearNodeToInsertParalel()
{
	int result = -1;
	float min = -1;

	for (int i = 1 ; i < m_pDoc->m_Graph->GetNodeCount();i++) {
		// check only unrouted nodes and nodes wich can be inserted
		if (m_pDoc->m_Graph->GetNodeState(i) == 0)  {
			if (min == -1) {
				result = i;
				min = m_pDoc->m_Graph->GetEdgeValue(0,m_pDoc->m_Graph->GetNode(i)->getId()); 
			} else if (min >= m_pDoc->m_Graph->GetEdgeValue(0,m_pDoc->m_Graph->GetNode(i)->getId())) {
				result = i;
				min = m_pDoc->m_Graph->GetEdgeValue(0,m_pDoc->m_Graph->GetNode(i)->getId());
			}
		}
	}
	return result;	
}

void CInsertionAlgorithm::SolveAdditionFarSeq()
{
	m_pDoc->m_Graph->CreateRoutes(0);
	m_pDoc->m_Graph->UpdateEdgeValues();
	InitVariables();
	BOOL routed = AllRouted();
	
	int routeId = SetNewRoute();
	while (!routed) {
		CountNearestAddition(routeId);
		int nodeId = ChooseFarNodeToInsert();
		while (nodeId != -1) {
			InsertNodeToRoute(nodeId,routeId);
			CountNearestAddition(routeId);
			nodeId = ChooseFarNodeToInsert();
		};
		routed = AllRouted();
		if (!routed) {
			routeId = SetNewRoute();
		}
	};

	m_pDoc->UpdateAllViews(NULL);
}

void CInsertionAlgorithm::SolveAdditionFarPar()
{
	m_pDoc->m_Graph->CreateRoutes(0);
	m_pDoc->m_Graph->UpdateEdgeValues();
	InitVariables();
	
	BOOL routed = AllRouted();
	
	while (!routed) {
		CountNearestAdditionParalel();
		int nodeId = ChooseFarNodeToInsertParalel();
		InsertNodeToRouteParalel(nodeId);
		routed = AllRouted();
	};
	m_pDoc->UpdateAllViews(NULL);
}

int CInsertionAlgorithm::ChooseFarNodeToInsert()
{
	int result = -1;
	float max = -1;

	for (int i = 1 ; i < m_pDoc->m_Graph->GetNodeCount();i++) {
		// check only unrouted nodes and nodes wich can be inserted
		if ((m_pDoc->m_Graph->GetNodeState(i) == 0) && 
			(m_pDoc->m_Graph->GetNode(i)->GetInsertIndex() != -1)) {
			if (max == -1) {
				result = i;
				max = m_pDoc->m_Graph->GetEdgeValue(0,m_pDoc->m_Graph->GetNode(i)->getId()); 
			} else if (max <= m_pDoc->m_Graph->GetEdgeValue(0,m_pDoc->m_Graph->GetNode(i)->getId())) {
				result = i;
				max = m_pDoc->m_Graph->GetEdgeValue(0,m_pDoc->m_Graph->GetNode(i)->getId()); 
			}
		}
	}
	return result;	
}

int CInsertionAlgorithm::ChooseFarNodeToInsertParalel()
{
	int result = -1;
	float max = -1;

	for (int i = 1 ; i < m_pDoc->m_Graph->GetNodeCount();i++) {
		// check only unrouted nodes and nodes wich can be inserted
		if (m_pDoc->m_Graph->GetNodeState(i) == 0)  {
			if (max == -1) {
				result = i;
				max = m_pDoc->m_Graph->GetEdgeValue(0,m_pDoc->m_Graph->GetNode(i)->getId()); 
			} else if (max <= m_pDoc->m_Graph->GetEdgeValue(0,m_pDoc->m_Graph->GetNode(i)->getId())) {
				result = i;
				max = m_pDoc->m_Graph->GetEdgeValue(0,m_pDoc->m_Graph->GetNode(i)->getId());
			}
		}
	}
	return result;	
}
