// InsertionAlgorithm.h: interface for the CInsertionAlgorithm class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_INSERTIONALGORITHM_H__1D6CEC12_C494_4797_B20E_6374837A8E5D__INCLUDED_)
#define AFX_INSERTIONALGORITHM_H__1D6CEC12_C494_4797_B20E_6374837A8E5D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Algorithm.h"

class CInsertionAlgorithm : public CAlgorithm  
{
public:
	int ChooseFarNodeToInsertParalel();
	void SolveAdditionFarPar();
	void SolveAdditionFarSeq();
	void SolveAdditionNearPar();
	void SolveAdditionNearSeq();
	void SolveAdditionBestPar();
	void SolveAdditionBestSeq();
	CInsertionAlgorithm();
	CInsertionAlgorithm(CVRPDoc* doc);
	virtual ~CInsertionAlgorithm();

private:
	int ChooseFarNodeToInsert();

	int ChooseNearNodeToInsertParalel();
	int ChooseNearNodeToInsert();
	void CountNearestInsertionParalel();
	void InsertNodeToRouteParalel(int NodeId);
	int ChooseNodeToInsertParalel();
	void CountNearestAdditionParalel();
	BOOL AllRouted();
	void InsertNodeToRoute(int NodeId,int RouteId);
	int ChooseNodeToInsert();
	int SetNewRoute();
	void InitVariables();
	void CountNearestAddition(int RouteId);
};

#endif // !defined(AFX_INSERTIONALGORITHM_H__1D6CEC12_C494_4797_B20E_6374837A8E5D__INCLUDED_)
