// Node.cpp: implementation of the CNode class.
//
//////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "Node.h"
#include "Globals.h"


#include <cmath>
#include <stdio.h>

IMPLEMENT_SERIAL(CNode, CObject, 0)

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif



//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CNode::CNode()
{
	m_nDemand	  = 10;
	m_nId		  = 0;
	m_nPoint.x	  = 0;
	m_nPoint.y    = 0;
	m_nRoute	  = -1;
	m_fAngle      = 0;
	m_nState	  = 0;
	m_bSelected   = false;
	m_fInsertCost = -1;
	m_nInsertIndex = -1;
	m_nInsertRouteId = -1;
}

CNode::~CNode()
{

}

//////////////////////////////////////////////////////////////////////
// Implementation
//////////////////////////////////////////////////////////////////////


void CNode::setLocation(CPoint location)
{
	m_nPoint.x = location.x;
	m_nPoint.y = location.y;
}

CPoint CNode::getLocation()
{
	return m_nPoint;
}

void CNode::setDemand(int demand)
{
	m_nDemand = demand;
}

int CNode::getDemand()
{
	return m_nDemand;
}

void CNode::setId(int id)
{
	m_nId = id;
}

int CNode::getId()
{
	return m_nId;
}

void CNode::setRouteId(int id)
{
	m_nRoute = id;
}

int CNode::getRouteId()
{
	return m_nRoute;
}

void CNode::setAngle(float angle) 
{
	m_fAngle = angle;
}

float CNode::getAngle()
{
	return m_fAngle;
}

BOOL CNode::isLocation(CPoint point)
{
	return  g_AppData->IsCloseTo(point,m_nPoint,nodeRadius);
}

BOOL CNode::getSelected()
{
	return m_bSelected;
}

void CNode::setSelected(BOOL value)
{
	m_bSelected = value;
}

void CNode::Serialize(CArchive &ar)
{
	if (ar.IsStoring()) {
		ar << m_nId << m_nDemand << m_nPoint.x << m_nPoint.y;
	}
	else {
		ar >> m_nId >> m_nDemand >> m_nPoint.x >> m_nPoint.y;
	}
}

void CNode::Show(CDC *pDC)
{
	CPoint point;
	point = g_AppData->LPtoDP(m_nPoint);
	if (m_bSelected) {
		CPen newPen(PS_DASHDOTDOT,3,(COLORREF) 0);
		CPen* pOldPen = pDC->SelectObject(&newPen);
		pDC->Ellipse(point.x-nodeRadius,point.y-nodeRadius,point.x+nodeRadius,point.y+nodeRadius);
		pDC->SelectObject(pOldPen);
		CString idText;
		idText.Format("%d",m_nId);
		pDC->TextOut(point.x,point.y,idText);
	} else {
		CPen newPen(PS_DASHDOTDOT,2,(COLORREF) 200000*m_nRoute);
		CPen* pOldPen = pDC->SelectObject(&newPen);
		pDC->Ellipse(point.x-nodeRadius,point.y-nodeRadius,point.x+nodeRadius,point.y+nodeRadius);
		pDC->SelectObject(pOldPen);
		CString idText;
		idText.Format("%d",m_nId);
		pDC->TextOut(point.x,point.y,idText);
	}
}

	

int CNode::GetState()
{
	return m_nState;
}

void CNode::SetState(int state)
{
	m_nState = state;
}

float CNode::GetInsertCost()
{
	return m_fInsertCost;
}

void CNode::SetInsertCost(float cost)
{
	m_fInsertCost = cost;
}

void CNode::SetInsertIndex(int id)
{
	m_nInsertIndex = id;
}

int CNode::GetInsertIndex()
{	
	return m_nInsertIndex;
}

int CNode::GetInsertRouteId()
{
	return m_nInsertRouteId;
}

void CNode::SetInsertRouteId(int id)
{
	m_nInsertRouteId = id;
}	
