// OptAlgorithm.cpp: implementation of the COptAlgorithm class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "VRP.h"
#include "OptAlgorithm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

COptAlgorithm::COptAlgorithm()
{

}

COptAlgorithm::COptAlgorithm(CVRPDoc* doc) 
	:CAlgorithm(doc)
{

}

COptAlgorithm::~COptAlgorithm()
{

}

void COptAlgorithm::Opt2(CRoute *route)
{
	CNode* firstFE;
	CNode* secondFE;
	CNode* firstSE;
	CNode* secondSE;
	float oldValue = 0;
	float newValue = 0;

	for (int i = 0; i < route->getLength()-1; i++) {
		firstFE = route->getNodeFromPos(i);
		secondFE = route->getNodeFromPos(i+1);
		for (int j = 0; j < route->getLength()-1; j++) {
		firstSE = route->getNodeFromPos(j);
		secondSE = route->getNodeFromPos(j+1);
		// check if the edges are not adjacent
		if ((firstFE->getId() != secondSE->getId()) &&
			(firstFE->getId() != firstSE->getId()) &&
			(secondFE->getId() != firstSE->getId())) {
				// count the distances 
				oldValue = m_pDoc->m_Graph->GetEdgeValue(firstFE->getId(),secondFE->getId()) +
						   m_pDoc->m_Graph->GetEdgeValue(firstSE->getId(),secondSE->getId());		
				newValue = m_pDoc->m_Graph->GetEdgeValue(firstFE->getId(),firstSE->getId()) +
						   m_pDoc->m_Graph->GetEdgeValue(secondFE->getId(),secondSE->getId());		
				if (oldValue > newValue) {
					route->exchangeEdges(i,j);
				}
			}		
		}
	}
}

void COptAlgorithm::SolveOpt2()
{
	for (int i = 0; i < m_pDoc->m_Graph->GetRouteCount(); i++) {
		Opt2(m_pDoc->m_Graph->GetRoute(i));
	}
}
