// Route.cpp: implementation of the CRoute class.
//
//////////////////////////////////////////////////////////////////////


#include <stdlib.h>
#include <math.h>


#include "stdafx.h"
#include "VRP.h"
#include "Route.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CRoute::CRoute()
{
	m_cost = 0;
	m_length = 0;
	m_demand = 0;
	m_state = 0;
	m_pNodeArray = NULL;
	m_pTempNodeArray = NULL;
}

CRoute::CRoute(const CRoute* route) 
{
	m_cost = route->m_cost;
	m_length = route->m_length;
	m_demand = route->m_demand;
	m_state = route->m_state;
	m_id = route->m_id;
	m_pNodeArray = NULL; 
	m_pNodeArray = new CNode*[m_length];
	for (int i=0; i < m_length; i++) {
		m_pNodeArray[i] = route->m_pNodeArray[i];
	}
	m_pTempNodeArray = NULL;
}

CRoute::~CRoute()
{
//	if (m_pNodeArray != NULL) delete[] m_pNodeArray;
}

//////////////////////////////////////////////////////////////////////
// Implementation
//////////////////////////////////////////////////////////////////////





void CRoute::setCost(float cost)
{
	m_cost = cost;
}

float CRoute::getCost()
{
	return m_cost;
}

int CRoute::getLength()
{
	return m_length;
}

void CRoute::setLength(int length)
{
	if (length == 0) {
		if (m_pNodeArray != NULL) delete[] m_pNodeArray;
		m_pNodeArray = NULL;
		m_length = 0;
	}
	if ((length > 0) && (length != m_length)) {
		if (m_pNodeArray == NULL) {
			m_pNodeArray = new CNode* [length];
			m_length = length;
		} else {
			if (length > m_length) {
				if (m_pTempNodeArray != NULL) delete[] m_pTempNodeArray;
				m_pTempNodeArray = new CNode* [length];
				for (int i=0; i < m_length;i++) 
					m_pTempNodeArray[i] = m_pNodeArray[i];
				if (m_pNodeArray != NULL) {
					delete[] m_pNodeArray;		
				}
				m_pNodeArray = new CNode*[length];
				for (i=0; i < length;i++) 
					m_pNodeArray[i] = m_pTempNodeArray[i];
				m_length = length;
			} else {
				m_length = length;
			}
		}
	}
}

bool CRoute::setNodeToPos(int pos, CNode *node)
{
	if ((pos >= 0) && (pos < m_length)) {
		m_pNodeArray[pos] = node;
		node->setRouteId(m_id);
		return true;
	}
	else 
		return false;
}

CNode* CRoute::getNodeFromPos(int pos)
{
	if ((pos >= 0) && (pos < m_length)) {
		return	m_pNodeArray[pos];
	}
	else 
		return NULL;
}

int CRoute::getId()
{
	return m_id;
}

void CRoute::setId(int id)
{
	m_id = id;
}

bool CRoute::isInterior(int id)
{
	if ((m_pNodeArray[0]->getId() == id) || (m_pNodeArray[m_length-1]->getId() == id))
		return false;
	else return true;
}

int CRoute::getDemand()
{
	return m_demand;
}

void CRoute::setDemand(int demand)
{
	m_demand = demand;
}



CNode* CRoute::getFirst()
{
	return m_pNodeArray[0];
}

CNode* CRoute::getLast()
{
	return m_pNodeArray[m_length-1];
}

int CRoute::getState()
{
	return m_state;
}	

void CRoute::setState(int state)
{
	m_state = state;
}

// exchange edges defined by first node position, the way to stay route
void CRoute::exchangeEdges(int first, int second)
{
	CNode* node;
	div_t div_result;
	div_result = div(second-first,2);
	for (int i = 1; i <= div_result.quot;i++) {
		node = m_pNodeArray[first+i];
		m_pNodeArray[first+i] = m_pNodeArray[(second+1)-i];
		m_pNodeArray[(second+1)-i] = node;
	}
}

void CRoute::AddNodeTail(CNode *node)
{
	CNode** TempArray;
	TempArray = new CNode*[m_length+1];
	for (int i = 0; i < m_length; i++) {
		TempArray[i] = m_pNodeArray[i];
	}
	TempArray[m_length] = node;
	m_length += 1;
	m_pNodeArray = TempArray;
}

int CRoute::GetLastCustId()
{
	BOOL test = true;
	int i = m_length-1;
	int result = 0;

	while ((test) && (m_length >=0)) {
		if (m_pNodeArray[i]->getId() != 0) {
			test = false;
			result = m_pNodeArray[i]->getId();
		}
		i--;
	}
	return result;
}

int CRoute::GetFirstCustId()
{
	BOOL test = true;
	int i = 0;
	int result = 0;

	while ((test) && (i < m_length)) {
		if (m_pNodeArray[i]->getId() != 0) {
			test = false;
			result = m_pNodeArray[i]->getId();
		}
		i++;
	}
	return result;
}

void CRoute::UpdateDemand()
{
	m_demand = 0;
	for (int i = 0;i < m_length; i++) {
		m_demand += m_pNodeArray[i]->getDemand();
	}
}

int CRoute::GetIndex(int id)
{
	BOOL test = true;
	int index = -1;
	int count = 0;
	while ((test) && (count < m_length-1)) {
		if (m_pNodeArray[count]->getId() == id) {
				index = count;
				test = false;
			}
		count++;
	}
	return index;
}

void CRoute::ExchangeNodes(int i, int j)
{
	CNode* node;
	node = m_pNodeArray[i];
	m_pNodeArray[i] = m_pNodeArray[j];
	m_pNodeArray[j] = node;
}

int CRoute::GetNodeId(int index)
{
	return m_pNodeArray[index]->getId();
}

void CRoute::InsertNode(int index, CNode *node)
{
	CNode** tempArray;
	tempArray = new CNode*[m_length+1];

	for (int i=0; i < index;i++) {
		tempArray[i] = m_pNodeArray[i];
	}
	for (i=index+1; i < m_length+1;i++) {
		tempArray[i] = m_pNodeArray[i-1];
	}
	tempArray[index] = node;
	m_pNodeArray = tempArray;
	m_length += 1;
}

