// Route.h: interface for the CRoute class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ROUTE_H__B1F5CD89_0AA3_47A8_AF95_86C91FAE007B__INCLUDED_)
#define AFX_ROUTE_H__B1F5CD89_0AA3_47A8_AF95_86C91FAE007B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Node.h"

class CRoute  
{
private:
	
	
	int m_state;
	
	CNode** m_pNodeArray;
	CNode** m_pTempNodeArray;
	float m_cost;
	int m_length;
	int m_id;
	int m_demand;

public:
	void InsertNode(int index,CNode* node);
	int GetNodeId(int index);
	void ExchangeNodes(int i,int j);
	int GetIndex(int id);
	CRoute(const CRoute* route);
	void UpdateDemand();
	int GetFirstCustId();
	int GetLastCustId();
	void AddNodeTail(CNode* node);
	void exchangeEdges(int first,int second);
	int getState();
	void setState(int state);
	CNode* getLast();
	CNode* getFirst();
	
	CNode* getNodeFromPos(int pos);
	bool setNodeToPos(int pos,CNode* node);
	
	int getLength();
	void setLength(int length);
	float getCost();
	void setCost(float cost);
	int getId();
	void setId(int id);
	int getDemand();
	void setDemand(int demand);

	bool isInterior(int id);
	CRoute();
	
	virtual ~CRoute();

};

#endif // !defined(AFX_ROUTE_H__B1F5CD89_0AA3_47A8_AF95_86C91FAE007B__INCLUDED_)
