// RouteDialog.cpp : implementation file
//

#include "stdafx.h"
#include "VRP.h"
#include "RouteDialog.h"
#include "Globals.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRouteDialog dialog


CRouteDialog::CRouteDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CRouteDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRouteDialog)
	m_RouteEdit = _T("");
	//}}AFX_DATA_INIT
}

CRouteDialog::CRouteDialog(CView* pView)
{
	m_pView = pView;
}


void CRouteDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRouteDialog)
	DDX_Text(pDX, IDC_EDIT1, m_RouteEdit);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CRouteDialog, CDialog)
	//{{AFX_MSG_MAP(CRouteDialog)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRouteDialog message handlers

void CRouteDialog::OnOK()
{

}

void CRouteDialog::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	
	CDialog::OnClose();
}

void CRouteDialog::OnCancel()
{
	if (m_pView != NULL) {
		m_pView->PostMessage(WM_CLOSE_ROUTE_DIALOG, IDCANCEL);
	}
	else {
		// for modal dialog
		CDialog::OnCancel();
	}
}

void CRouteDialog::SetData(CVRPDoc *doc)
{
	m_pDoc = doc;
	CString text; 
	int TotalCost = 0;
	int VehicleCount = 0;
	m_RouteEdit = "";
	for (int i=0; i < m_pDoc->m_Graph->GetRouteCount();i++) {
		if (m_pDoc->m_Graph->GetRoute(i)->getLength() != 0) {
			text += "Cesta " + g_AppData->IntToStr(i) + " :";
			for (int j=0; j < m_pDoc->m_Graph->GetRoute(i)->getLength(); j++) {
				text += g_AppData->IntToStr(m_pDoc->m_Graph->GetRoute(i)->GetNodeId(j)); 
				text += "  ";
			}
			TotalCost += m_pDoc->m_Graph->CountRouteCost(i);
			text += "Demand : " + g_AppData->IntToStr(m_pDoc->m_Graph->GetRouteDemand(i));
			text += "\r\n";
			m_RouteEdit += text;
			text = "";
			VehicleCount++;
		}
	}
	CString str;
	str.Format("%1.2f",float(TotalCost));
	m_RouteEdit += " Total cost" + str; 
	m_RouteEdit += " Vehicle :" + g_AppData->IntToStr(VehicleCount); 
	UpdateData(FALSE);
}

