// SolveDialog.cpp : implementation file
//

#include "stdafx.h"
#include "VRP.h"
#include "SolveDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSolveDialog dialog


CSolveDialog::CSolveDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CSolveDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSolveDialog)
	m_sAlgCombo = _T("");
	m_sVerCombo = _T("");
	m_nVehicleEdit = 0;
	m_fLambdaEdit = 0.0f;
	m_fMuEdit = 0.0f;
	m_sOptCombo = _T("");
	//}}AFX_DATA_INIT
}

void CSolveDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSolveDialog)
	DDX_Control(pDX, IDC_OPT_COMBO, m_cOptCombo);
	DDX_Control(pDX, IDC_MU_EDIT, m_cMuEdit);
	DDX_Control(pDX, IDC_LAMBDA_EDIT, m_cLambdaEdit);
	DDX_Control(pDX, IDC_VEHICLE_EDIT, m_cVehicleEdit);
	DDX_Control(pDX, IDC_VERSION_COMBO, m_cVerCombo);
	DDX_Control(pDX, IDC_ALG_COMBO, m_cAlgCombo);
	DDX_CBString(pDX, IDC_ALG_COMBO, m_sAlgCombo);
	DDX_CBString(pDX, IDC_VERSION_COMBO, m_sVerCombo);
	DDX_Text(pDX, IDC_VEHICLE_EDIT, m_nVehicleEdit);
	DDV_MinMaxInt(pDX, m_nVehicleEdit, 1, 1000);
	DDX_Text(pDX, IDC_LAMBDA_EDIT, m_fLambdaEdit);
	DDV_MinMaxFloat(pDX, m_fLambdaEdit, 0.f, 1.f);
	DDX_Text(pDX, IDC_MU_EDIT, m_fMuEdit);
	DDV_MinMaxFloat(pDX, m_fMuEdit, 0.f, 1.f);
	DDX_CBString(pDX, IDC_OPT_COMBO, m_sOptCombo);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSolveDialog, CDialog)
	//{{AFX_MSG_MAP(CSolveDialog)
	ON_CBN_EDITCHANGE(IDC_ALG_COMBO, OnEditchangeAlgCombo)
	ON_CBN_SELCHANGE(IDC_ALG_COMBO, OnSelchangeAlgCombo)
	ON_CBN_SELCHANGE(IDC_VERSION_COMBO, OnSelchangeVersionCombo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSolveDialog message handlers

void CSolveDialog::OnEditchangeAlgCombo() 
{

}	

BOOL CSolveDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	// initialize Algorithm Combo	
	m_cAlgCombo.AddString("Savings Algorithm");
	m_cAlgCombo.AddString("Insertion Algorithm");
	m_cAlgCombo.AddString("2-phase Algorithm");

	m_sAlgCombo = "Select algorithm";
	
	// initialize Version Combo
	m_cVerCombo.EnableWindow(false);

	m_sVerCombo = "Select version";
	
	// initialize Optimalize Combo
	m_sOptCombo = "Select algorithm";
	m_cOptCombo.AddString("2-Opt Algorithm");

	// initialize Vehicle edit
	m_cVehicleEdit.EnableWindow(false);
	m_nVehicleEdit = 1;
	// initialize parameters edit 
	m_cLambdaEdit.EnableWindow(false);
	m_cMuEdit.EnableWindow(false);
	
	
	UpdateData(false);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSolveDialog::OnSelchangeAlgCombo() 
{
	m_cVehicleEdit.EnableWindow(false);
	m_cLambdaEdit.EnableWindow(false);
	m_cMuEdit.EnableWindow(false);

	switch (m_cAlgCombo.GetCurSel()) {
	case 0 :
		m_cVerCombo.EnableWindow(true);

		m_cVerCombo.ResetContent();
		m_cVerCombo.AddString("Sequential");
		m_cVerCombo.AddString("Parallel");
		m_cVerCombo.AddString("Sequential + Parameter");
		m_cVerCombo.AddString("Parallel + Parameter");
		break;
	case 1 :
		m_cVerCombo.EnableWindow(true);

		m_cVerCombo.ResetContent();
		m_cVerCombo.AddString("M&J Insertion");
		m_cVerCombo.AddString("Best - Nearest Addition Sequential");
		m_cVerCombo.AddString("Best - Nearest Addition Parallel");
		m_cVerCombo.AddString("Near - Nearest Addition Sequential");
		m_cVerCombo.AddString("Near - Nearest Addition Parallel");
		m_cVerCombo.AddString("Far - Nearest Addition Sequential");
		m_cVerCombo.AddString("Far - Nearest Addition Parallel");
		break;
	case 2 :
		m_cVerCombo.EnableWindow(true);

		m_cVerCombo.ResetContent();
		m_cVerCombo.AddString("Sweep algorithm");
		m_cVerCombo.AddString("F&J Algorithm");
		break;
	}
	
	UpdateData(false);
}

void CSolveDialog::OnSelchangeVersionCombo() 
{
	m_cVehicleEdit.EnableWindow(false);
	m_cLambdaEdit.EnableWindow(false);
	m_cMuEdit.EnableWindow(false);


	switch (m_cAlgCombo.GetCurSel()) {
	case 0 :
		if ((m_cVerCombo.GetCurSel() == 2) || (m_cVerCombo.GetCurSel() == 3)) {
			m_cLambdaEdit.EnableWindow(true);
		}
		break;

	case 1 :
		if (m_cVerCombo.GetCurSel() == 0) {
			m_cLambdaEdit.EnableWindow(true);
			m_cMuEdit.EnableWindow(true);
		}
		break;
	case 2 :
		if (m_cVerCombo.GetCurSel() == 1) {
			m_cVehicleEdit.EnableWindow(true);
		}
		break;
	}
	
}
