// SweepAlgorithm.cpp: implementation of the CSweepAlgorithm class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "VRP.h"
#include "SweepAlgorithm.h"
#include <algorithm>
using namespace std;

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

const float PI = float(3.14);

bool operator<(const sAngle& a, const sAngle& b) {
    return a.Value > b.Value;
}


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSweepAlgorithm::CSweepAlgorithm()
{

}

CSweepAlgorithm::CSweepAlgorithm(CVRPDoc* doc) 
	:CAlgorithm(doc)
{
}

CSweepAlgorithm::~CSweepAlgorithm()
{

}

float CSweepAlgorithm::CountAngle(int x,int y)
{
	float r;
	r = float(sqrt(pow(x,2) + pow(y,2)));
	if (r != 0) {
		float t1 = float(acos(y/r));
		if (x >= 0) return t1;
		else return (2*PI)-t1;
	} else return 0;
}

void CSweepAlgorithm::SetAngles()
{
	CPoint DepotLoc;
	DepotLoc = m_pDoc->m_Graph->GetNode(0)->getLocation();
	for (int i=1;i < m_pDoc->m_Graph->GetNodeCount();i++) {
		int x1 = m_pDoc->m_Graph->GetNode(i)->getLocation().x - DepotLoc.x;
		int y1 = m_pDoc->m_Graph->GetNode(i)->getLocation().y - DepotLoc.y;
		m_pAngleArray[i-1].NodeId = i;
		m_pAngleArray[i-1].Value = CountAngle(x1,y1);
	}
	sort(m_pAngleArray,m_pAngleArray+m_pDoc->m_Graph->GetNodeCount()-1);
}



void CSweepAlgorithm::InitVariables()
{
	m_pAngleArray = new sAngle[m_pDoc->m_Graph->GetNodeCount()-1];
}

void CSweepAlgorithm::RouteCustomers()
{
	int ActualRouteId = 0;
	int Demand;
	int CustomerCount = m_pDoc->m_Graph->GetNodeCount()-1;
	sAngle Angle;
	m_pDoc->m_Graph->AddRoute();
	m_pDoc->m_Graph->AddNodeToRouteTail(0,m_pDoc->m_Graph->GetNode(0));
	for (int i=0; i < CustomerCount ;i++) {
		Angle = m_pAngleArray[i];
		Demand = m_pDoc->m_Graph->GetRouteDemand(ActualRouteId) + 
				 m_pDoc->m_Graph->GetNodeDemand(Angle.NodeId); 
		if (Demand > m_pDoc->m_Graph->GetCapacity()) {
			m_pDoc->m_Graph->AddNodeToRouteTail(ActualRouteId,m_pDoc->m_Graph->GetNode(0));
			m_pDoc->m_Graph->AddRoute();
			ActualRouteId++; 
			m_pDoc->m_Graph->AddNodeToRouteTail(ActualRouteId,m_pDoc->m_Graph->GetNode(0));
		}
		m_pDoc->m_Graph->IncRouteDemand(ActualRouteId,m_pDoc->m_Graph->GetNodeDemand(Angle.NodeId)); 
		m_pDoc->m_Graph->AddNodeToRouteTail(ActualRouteId,m_pDoc->m_Graph->GetNode(Angle.NodeId));
		m_pDoc->m_Graph->GetNode(Angle.NodeId)->setRouteId(ActualRouteId);
	}
	m_pDoc->m_Graph->AddNodeToRouteTail(ActualRouteId,m_pDoc->m_Graph->GetNode(0));
}

void CSweepAlgorithm::Solve()
{
	m_pDoc->m_Graph->CreateRoutes(0);
	m_pDoc->m_Graph->UpdateEdgeValues();
	InitVariables();
	SetAngles();
	RouteCustomers();
	m_pDoc->UpdateAllViews(NULL);
}
