// System.cpp: implementation of the CSystem class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "VRP.h"
#include "System.h"

#include <stdio.h>
#include <cmath>
#include <sstream>
#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif



//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSystem::CSystem()
{
	m_bGraphChange = false;
	m_SetVehicleCapacity = false;
}

CSystem::~CSystem()
{

}


void CSystem::setWndRect(CRect rect)
{
	m_WndRect = rect;
}

CPoint CSystem::LPtoDP(CPoint point)
{
	CPoint p;
	p.x = int(floor((float(m_WndRect.Width()-(2*BORDER)) / float(m_GraphRect.right)) * point.x));
	p.y = int(floor((float(m_WndRect.Height()-(2*BORDER)) / float(m_GraphRect.bottom)) * point.y));
	p.x += BORDER; 

	p.y += BORDER; 

	return p;
}


void CSystem::setGraphRect(CRect rect)
{
	m_GraphRect = rect; 
}

CPoint CSystem::DPtoLP(CPoint point)
{
	CPoint p;
	p.x = float(point.x-BORDER) / (float(m_WndRect.Width()-(2*BORDER)) / float(m_GraphRect.right));
	p.y = float(point.y-BORDER) / (float(m_WndRect.Height()-(2*BORDER)) / float(m_GraphRect.bottom));
	return p;
}

CString CSystem::IntToStr(int num)
{
	CString str;
	str.Format("%d",num);
	return str;
}


// convert std::string to integer
int CSystem::StringToInt(string str)
{
	istringstream stm(str);
	
	int number = -1;

    stm >> number;

	return number;
}

BOOL CSystem::IsCloseTo(CPoint p1, CPoint p2, int dist)
{
	BOOL test = false;
	float ratioX = (float(m_WndRect.Width()-(2*BORDER)) / float(m_GraphRect.right));
	float ratioY = (float(m_WndRect.Height()-(2*BORDER)) / float(m_GraphRect.bottom));
	float x1 = float(p1.x-BORDER) / ratioX;
	float y1 = float(p1.y-BORDER) / ratioY;
	float distX = dist / ratioX;
	float distY = dist / ratioY;
	
	if ((((p2.x - distX) <= x1) && ((p2.x + distX) >= x1)) &&
		(((p2.y - distY) <= y1) && ((p2.y + distY) >= y1))) 
		test = true;

	return test;	
}

CRect CSystem::getGraphRect()
{
	return m_GraphRect;
}
