// VRPView.h : interface of the CVRPView class
//
/////////////////////////////////////////////////////////////////////////////

#include "VRPDoc.h"
#include "Globals.h"
#include "NewNodeDialog.h"
#include "NewInstanceDlg.h"
#include "NodeDialog.h"
#include "RouteDialog.h"
#include "SolveDialog.h"


#if !defined(AFX_VRPVIEW_H__1D6050BE_0047_4427_A9AD_F1FE91689EF8__INCLUDED_)
#define AFX_VRPVIEW_H__1D6050BE_0047_4427_A9AD_F1FE91689EF8__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


class CVRPView : public CView
{
protected: // create from serialization only
	CVRPView();
	DECLARE_DYNCREATE(CVRPView)

// Attributes
public:
	CVRPDoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CVRPView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CVRPView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CVRPView)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnToolAddnode();
	afx_msg void OnUpdateToolAddnode(CCmdUI* pCmdUI);
	afx_msg void OnToolSelectnode();
	afx_msg void OnUpdateToolSelectnode(CCmdUI* pCmdUI);
	afx_msg void OnViewNodeinfo();
	afx_msg void OnUpdateViewNodeinfo(CCmdUI* pCmdUI);
	afx_msg void OnSolve();
	afx_msg void OnUpdateViewRouteinfo(CCmdUI* pCmdUI);
	afx_msg void OnViewRouteinfo();
	afx_msg void OnNewInstance();
	afx_msg void OnSolveSequentialsavingsalgorithmsBasic2opt();
	afx_msg void OnSolveSavingsalgorithmsSequentialBasic();
	afx_msg void OnSolveSequentialsavingsalgorithmsParameter();
	afx_msg void OnSolveSequentialsavingsalgorithmsParameter2opt();
	afx_msg void OnSolveParallelsavingsalgorithmsBasic();
	afx_msg void OnSolveParallelsavingsalgorithmsBasic2opt();
	afx_msg void OnSolveParallelsavingsalgorithmsParameter();
	afx_msg void OnSolveParallelsavingsalgorithmsParameter2opt();
	afx_msg void OnSolve2phasealgorithmsFjalgorithm();
	afx_msg void OnSolve2phasealgorithmsFjalgorithm2opt();
	afx_msg void OnSolve2phasealgorithmsSweepalgorithm();
	afx_msg void OnSolve2phasealgorithmsSweepalgorithm2opt();
	afx_msg void OnSolveInsertionalgorithmsMjalgorithm();
	afx_msg void OnSolveInsertionalgorithmsMjalgorithm2opt();
	afx_msg void OnSolveInsertionparallelalgorithmsBestnodefirst();
	afx_msg void OnSolveInsertionalgorithmsparallelalgorithmsFarestnodefirst();
	afx_msg void OnSolveInsertionalgorithmsparallelalgorithmsNearestnodefirst();
	afx_msg void OnSolveInsertionalgorithmssequentialalgorithmsBestnodefirst();
	afx_msg void OnSolveInsertionalgorithmssequentialalgorithmsFaresr();
	afx_msg void OnSolveInsertionalgorithmssequentialalgorithmsNearestnodefirst();
	afx_msg void OnSolveInsertionalgorithmsparallelalgorithmsBestnodefirst2opt();
	afx_msg void OnSolveInsertionalgorithmsparallelalgorithmsFarestnodefirst2opt();
	afx_msg void OnSolveInsertionalgorithmsparallelalgorithmsNearest2opt();
	afx_msg void OnSolveInsertionalgorithmssequentialalgorithmsBest2opt();
	afx_msg void OnSolveInsertionalgorithmssequentialalgorithmsFarest2opt();
	afx_msg void OnSolveInsertionalgorithmssequentialalgorithmsNearest2opt();
	afx_msg void OnUpdateSolveAlgorithm(CCmdUI* pCmdUI);
	afx_msg void OnUpdateOnUpdateSolveAlgorithm(CCmdUI* pCmdUI);
	//}}AFX_MSG
	afx_msg LRESULT OnCloseInfoDialog(WPARAM wParam,LPARAM lParam);
	afx_msg LRESULT OnCloseRouteDialog(WPARAM wParam,LPARAM lParam);
	DECLARE_MESSAGE_MAP()
private:
	BOOL m_bSolveDlg;
	BOOL m_bRouteDlg;
	BOOL m_bNodeDlg;

	BOOL m_bSlctTool;
	BOOL m_bAddTool;
	CNodeDialog* m_pNodeDlg;
	CRouteDialog* m_pRouteDlg;
};

#ifndef _DEBUG  // debug version in VRPView.cpp
inline CVRPDoc* CVRPView::GetDocument()
   { return (CVRPDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_VRPVIEW_H__1D6050BE_0047_4427_A9AD_F1FE91689EF8__INCLUDED_)
