namespace("org.dforms.dom");
with(org.dforms.dom){
	org.dforms.dom.Element={};
	Element.getLocalName=function(element){
		var ret=element.localName;
		if(!ret){
			ret=element.nodeName;
			if(ret.indexOf(':')>0){
				ret=ret.substr(ret.indexOf(':')+1);
			}
		}
		return ret;
	};
	Element.isDescendantOrSelf=function(parent, element){
		var ret=false;
		if(parent == element){
			ret=true;
		}else{
			var childNodes=parent.childNodes;
			for(var i=0;i<childNodes.length;i++){
				var node=childNodes[i];
				if(node.nodeType == 1){
					ret=Element.isDescendantOrSelf(node, element);
					if(ret==true)break;
				}
			}
		}
		return ret;
	};
	Element.getParentByTagName=function(element, name){
		var ret=element.parentNode;
		if(ret!=null && ret.nodeName.toLowerCase() != name.toLowerCase()){
			ret=Element.getParentByTagName(ret, name);
		}
		return ret;
	};
	Element.getAttributeNS=function(element, namespace, name){
		var attr=Element.getAttributeNodeNS(element, namespace, name);
		return attr==null?null:attr.value;
	};
	Element.getAttributeNodeNS=function(element, namespace, name){
		var ret=null;
		if(element.getAttributeNS){
			ret=element.getAttributeNodeNS(namespace, name);
		}else{
			for(var i=0;i<element.attributes.length;i++){
				var attr=element.attributes[i];
				var qname=QNameFactory.getQName(element,attr.name);
				if(attr.name===name && qname.namespace===namespace){
					ret=attr; break;
				}
			}
		}
		return ret;
	};
	Element.addEventListener=function(element, type, handler, capture){
		if(element.addEventListener){
			element.addEventListener(type, handler, capture);
		}else{
			element.attachEvent('on'+type, handler);
		}
	};
	Element.removeEventListener=function(element, type, handler){
		if(element.removeEventListener){
			element.removeEventListener(type, handler);
		}else{
			element.detachEvent('on'+type, handler);
		}
	};
	org.dforms.dom.Document={};
	Document.createElementNS=function(ns, name){
		var ret;
		if(document.createElementNS){
			ret=document.createElementNS(ns,name);
		}else{
			ret=document.createElement(name);
		}
		return ret;
	};
	Document.getNamespace=function(prefix, ctx){
		var attr=ctx.getAttributeNode('xmlns:'+prefix);
		if(attr){
			return attr.value;
		}
		if(ctx.parentNode && ctx.parentNode.nodeType==1){
			return Document.getNamespace(prefix, ctx.parentNode);
		}
		return null;
	};
}