namespace("org.dforms.dom");
with(org.dforms.dom){
	org.dforms.dom.Event={};
	Event.addEventListener=function(element, type, handler, capture){
		if(element.addEventListener){
			element.addEventListener(type, handler, capture);
		}else{
			Event._addEventListenerIE(element,type, handler);
		}
	};
	Event.removeEventListener=function(element, type, handler){
		if(element.removeEventListener){
			element.removeEventListener(type, handler);
		}else{
			Event._removeEventListenerIE(element, type, handler);
		}
	};
	Event._addEventListenerIE=function(element, type, handler){
		var listeners=element[type+'Listeners'];
		if(!listeners) {
			listeners=element[type+'Listeners']=[];
			var wrapper=function(event) {
				event.target = event.srcElement;
				event.currentTarget = element;
				event.pageX=event.clientX+document.body.scrollLeft+document.documentElement.scrollLeft;
				event.pageY=event.clientY+document.body.scrollTop+document.documentElement.scrollTop;
				event.stopPropagation=function(){
					event.cancelBubble=true;
				}
				for( var i=0; i<listeners.length; i++){
					listeners[i](event) ;
				}
			};
			element.attachEvent('on'+type, wrapper);
		}
		listeners[listeners.length] = handler;
	};
	Event._removeEventListenerIE=function(element, type, handler){
		var listeners=elm[type+'Listeners'];
		var found=false;
		if(listeners) {
			for( var i=0; i<listeners.length; i++){
				if(listeners[i]==handler){
					found=true;
				}
				if(found && i<listeners.length-1){
					listeners[i]=listeners[i+1];
				}
			}
			if(found){
				listeners.pop();
			}
		}
	};
}