function Package(){
}
function Exception(description){
	this.description=description;
}
Exception.prototype.toString=function(){
	return this.description;
};
function _namespace(elements){
	var ctx=this;
	for(var i=0;i<elements.length;i++){
		var element=elements[i];
		if(!ctx[element]){
			ctx[element]=new Package();
		}
		ctx=ctx[element];
	}
	return ctx;
}
function namespace(ns){
	if(ns.indexOf("http://")===0){
		var sub=ns.substr("http://".length);
		if(sub.charAt(sub.length-1)=='/'){
			sub=sub.substring(0,sub.length-1);
		}
		var subs=sub.split('/');
		var path=subs.shift().split('.');
		if(path[0]=="www"){
			path.shift();
		}
		path.reverse();
		return _namespace(path.concat(subs));
	}else{
		return _namespace(ns.split('.'));
	}
}
function depends(packageName){
	var pkgs=packageName.split('.');
	var pack=this;
	for(var i=0;i<pkgs.length;i++){
		var pkg=pkgs[i];
		pack=pack[pkg];
		if(!pack){
			throw new Exception("Undeclared dependency package '"+packageName+"'. Perhaps a *.js file is not linked?");
		}
	}
}
function URL(){
	switch(arguments.length){
		case 1:
			this.location=arguments[0];
		break;
		case 2:
			this.location=URL.parse(arguments[0],arguments[1]);
		break;
	}
}
URL.prototype.toString=function(){
	return this.location;
};
URL.prototype.valueOf=function(){
	return this.location;
};
URL.parse=function(base, url){
	var ret;
	if(url.indexOf("http://")===0){	// absolute
		ret=url;
	}else if(url.charAt(0)=='/'){	// server relative
		ret=base.substring(0, base.indexOf('/',"http://".length));
		ret+=url;
	}else{
		ret=base.substring(0, base.lastIndexOf('/')+1);
		ret+=url;
	}
	return ret;
};
Object.prototype.toString=function(){
	var ret="";
	if(this instanceof String){
		ret=this;
	}else if(this instanceof Function){
	}else{
		ret="{";
		for(var name in this){
			if(this[name] instanceof Array){
				ret+=name+":["+this[name].toString()+"],";
			}else if(this[name] instanceof Function){
			}else{
				ret+=name+":"+this[name].toString()+",";
			}
		}
		ret=ret.substring(0, ret.length-1);
		ret+="}\n";
	}
	return ret;
};