namespace("org.dforms.xml");
with(org.dforms.xml){
	/**
	 * XML qualified name.
	 */
	org.dforms.xml.QName=function(namespace, localName){
		this.namespace=namespace;
		this.localName=localName;
	};
	QName.prototype.toString=function(){
		return "{"+this.namespace+"}"+this.localName;
	};
	QName.prototype.equals=function(obj){
		if(obj instanceof QName){
			return obj.toString()==this.toString();
		}
		return false;
	};
	/**
	 * QName factory.
	 */
	org.dforms.xml.QNameFactory={};
	QNameFactory.getQNameNS=function(ns, localName){
		var nss=this[ns];
		if(!nss){
			nss={};
			this[ns]=nss;
		}
		if(!nss[localName]){
			nss[localName]=new QName(ns, localName);
		}
		return nss[localName];
	};
	QNameFactory.getQName=function(ctx, qname){
		var prefix="";
		var localName=qname;
		var q_name=qname.split(':');
		if(q_name.length>1){
			prefix=q_name[0];
			localName=q_name[1];
		}
		var ns=Document.getNamespace(prefix, ctx);
		var qn=QNameFactory.getQNameNS(ns, localName);
		return qn;
	};
}