namespace("org.dforms.ui");
depends("org.dforms.dom");
with(org.dforms.ui){
	org.dforms.ui.Movement={};
	Movement.selectstart=function(){return false};
	Movement.mousedown=function(event){
		Movement.mouseDown=true;
		Movement.instance=event.currentTarget;
		Movement.handle=event.target;
	};
	Movement.mouseup=function(event){
		if(Movement.instance){
			Movement.mouseDown=false;
			Movement.handle.style.cursor="";
			if(Movement.onselectstart){
				document.onselectstart=Movement.onselectstart;
				document.documentElement.style.MozUserSelect="";
			}
			Movement.moveStarted=false;
		}
	};
	Movement.mousemove=function(event){
		if(Movement.mouseDown){
			var ctx=Movement.instance;
			if(Movement.moveStarted){
				ctx.style.left=(event.pageX-Movement.dx)+'px';
				ctx.style.top=(event.pageY-Movement.dy)+'px';
			}else{
				Movement.moveStarted=true;
				Movement.onselectstart=document.onselectstart;
				document.onselectstart=Movement.selectstart;
				document.documentElement.style.MozUserSelect="none";
				Movement.handle.style.cursor="move";
				var left=parseInt(ctx.style.left.substring(0,ctx.style.left.length-2));
				var top=parseInt(ctx.style.top.substring(0,ctx.style.top.length-2));
				Movement.dx=event.pageX-left;
				Movement.dy=event.pageY-top;
			}
			Movement.IEShit.adjustIFrame(ctx);
		}
	};
	Movement.IEShit={};
	Movement.IEShit.adjustIFrame=function(ctx){
		if(document.all){
			var win=ctx.window;
			var iframe=ctx.iframe;
			if(!iframe){
				iframe=org.dforms.dom.Document.createElementNS(null, "iframe");
				iframe.setAttribute("frameborder","0");
				iframe.style.position="absolute";
				iframe.style.width=win.offsetWidth;
				iframe.style.height=win.offsetHeight;
				ctx.style.zIndex=10000;
				iframe.style.zIndex=9999;
				ctx.iframe=iframe;
				document.documentElement.getElementsByTagName("body")[0].appendChild(iframe);
			}
			iframe.style.top=ctx.style.top;
			iframe.style.left=ctx.style.left;
		}
	}
	Movement.IEShit.disposeIFrame=function(ctx){
		if(ctx.iframe){
			var body=document.documentElement.getElementsByTagName("body")[0];
			body.removeChild(ctx.iframe);
			ctx.iframe=null;
		}
	}
	org.dforms.dom.Event.addEventListener(document, "mouseup", Movement.mouseup);
	org.dforms.dom.Event.addEventListener(document, "mousemove", Movement.mousemove);
}