namespace("org.dforms.ui");
depends("org.dforms.dom");
with(org.dforms.ui){
	org.dforms.ui.Window=function(view, className, locale, title){
		if(view){
			this.view=view;
			this.title=title;
			this.locale=locale;
			this.setResourceBundle(locale);
			this.createImpl(className);
			this.addWindow();
			this.addShade();
			this.addTitleBar();
			this.setTitle(this.title);
			this.addCtrl("\u00D7",this.close, this.rb.close);
			this.setPosition(view);
		}
	};
	Window.htmlns="http://www.w3.org/1999/xhtml";
	Window.l10n={};
	Window.l10n.close="Close";
	Window.prototype.paint=function(){
		if(this.impl){
			var body=document.documentElement.getElementsByTagName("body")[0];
			body.appendChild(this.impl);
		}
		if(!document.all){
			var style=this.impl.shade.style;
			style.width=(this.impl.window.offsetWidth-4)+"px";
			style.height=(this.impl.window.offsetHeight-4)+"px";
			style.top="8px";
			style.left="8px";
		}
		org.dforms.dom.Event.addEventListener(this.impl, "mousedown", org.dforms.ui.Movement.mousedown);
		org.dforms.ui.Movement.IEShit.adjustIFrame(this.impl);
	}
	Window.prototype.createImpl=function(className){
		var cn=className?"window "+className:"window";
		this.impl=this.createElement("div",{className:cn});
		this.impl.style.zIndex=10000;
	}
	Window.prototype.addShade=function(){
		var ret=this.createElement("div",{className:"shade"});
		this.impl.appendChild(ret);
		this.impl.shade=ret;
		return ret;
	}
	Window.prototype.addWindow=function(){
		var table=this.createElement("table");
		table.appendChild(this.createElement("thead"));
		var tbody=this.createElement("tbody");
		var tr=this.createElement("tr");
		var td=this.createElement("td",{colSpan:3, className:"content"});
		tr.appendChild(td);
		tbody.appendChild(tr);
		table.appendChild(tbody);
		this.impl.appendChild(table);
		this.impl.window=table;
		this.impl.window.content=td;
		return table;
	}
	Window.prototype.addTitleBar=function(){
		var titleBar=this.createElement("tr",{className:"titleBar"});
		var td=this.createElement("td",{className:"ctrl-left"});
		titleBar.leftCtrl=td;
		titleBar.appendChild(td);
		td=this.createElement("td",{className:"title"},{mousedown:org.dforms.ui.Movement.mousedown},this.title);
		titleBar.titleArea=td;
		titleBar.appendChild(td);
		td=this.createElement("td",{className:"ctrl-right"});
		titleBar.rightCtrl=td;
		titleBar.appendChild(td);
		this.impl.window.titleBar=titleBar;
		this.impl.window.childNodes[0].appendChild(titleBar);
		return titleBar;
	}
	Window.prototype.setTitle=function(title){
		var titleNode=this.impl.window.titleBar.titleArea;
		var nodes=titleNode.childNodes;
		for(var i=0;i<nodes.length;i++){
			titleNode.removeChild(nodes[i]);
		}
		titleNode.appendChild(document.createTextNode(title));
	}
	Window.prototype.addCtrl=function(content, handler, titleText, left){
		var titleBar=this.impl.window.titleBar;
		var ctrl=this.createElement("div",{className:"ctrl",title:titleText,envelope:this},{click:handler},content);
		if(left){
			titleBar.leftCtrl.appendChild(ctrl);
		}else{
			titleBar.rightCtrl.appendChild(ctrl);
		}
	}
	Window.prototype.removeAllCtrl=function(left){
		var ctx=this.impl.window.titleBar;
		ctx=left?ctx.leftCtrl:ctx.rightCtrl;
		while(ctx.childNodes.length>0){
			ctx.removeChild(ctx.childNodes[0]);
		}
	}
	Window.prototype.addContent=function(node){
		this.impl.window.content.appendChild(node);
	}
	Window.prototype.createElement=function(localName, attrs, events, value){
		var ret=org.dforms.dom.Document.createElementNS(Window.htmlns, localName);
		for(var attr in attrs){
			ret[attr]=attrs[attr];
		}
		for(var evt in events){
			org.dforms.dom.Event.addEventListener(ret, evt, events[evt]);
		}
		if(value){
			ret.appendChild(document.createTextNode(value));
		}
		return ret;
	}
	Window.prototype.setPosition=function(view){
		if(view){
			this.x=0;
			this.y=0;
			var parent=view;
			while(parent.offsetParent){
				this.x+=parent.offsetLeft;
				this.y+=parent.offsetTop;
				parent=parent.offsetParent;
			}
			this.impl.style.left=this.x+"px";
			this.impl.style.top=this.y+"px";
		}
	}
	Window.prototype.setResourceBundle=function(locale){
		this.rb=this.constructor.l10n[locale];
		if(!this.rb){
			this.rb=this.constructor.l10n;
		}
	}
	Window.prototype.close=function(event){
		var ctx=event?event.currentTarget.envelope:this;
		ctx=ctx.impl;
		org.dforms.ui.Movement.IEShit.disposeIFrame(ctx);
		var body=document.documentElement.getElementsByTagName("body")[0];
		body.removeChild(ctx);
	}
}