<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:d="http://www.dforms.org/1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template name="dforms-a-button" match="*[contains(name(), 'button-action')]" mode="render">
		<xsl:param name="namespace"/>
		<xsl:param name="locale"/>
		<xsl:param name="view" select="."/>
		<xsl:param name="model"/>
		<xsl:param name="name"/>
		<xsl:param name="id"/>
		<xsl:variable name="type" select="$view/d:meta[@name='type']"/>
		<xsl:variable name="desc" select="d:desc[lang($locale) or not(@xml:lang)][1]"/>
		<xsl:element name="input">
			<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
			<xsl:attribute name="class">dforms-a-button</xsl:attribute>
			<xsl:apply-templates select="$desc/@short-desc" mode="add-title"/>
			<xsl:choose>
				<xsl:when test="$type='submit'">
					<xsl:call-template name="createSubmit">
						<xsl:with-param name="namespace" select="$namespace"/>
						<xsl:with-param name="model" select="$model"/>
						<xsl:with-param name="view" select="$view"/>
						<xsl:with-param name="desc" select="$desc"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$type='link'">
					<xsl:call-template name="createLink">
						<xsl:with-param name="namespace" select="$namespace"/>
						<xsl:with-param name="view" select="$view"/>
						<xsl:with-param name="model" select="$model"/>
						<xsl:with-param name="desc" select="$desc"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$type='window'">
					<xsl:call-template name="createNewWindow">
						<xsl:with-param name="namespace" select="$namespace"/>
						<xsl:with-param name="view" select="$view"/>
						<xsl:with-param name="model" select="$model"/>
						<xsl:with-param name="desc" select="$desc"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="createSubmit">
						<xsl:with-param name="namespace" select="$namespace"/>
						<xsl:with-param name="view" select="$view"/>
						<xsl:with-param name="model" select="$model"/>
						<xsl:with-param name="desc" select="$desc"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:apply-templates select="d:attr" mode="add-attrs">
				<xsl:with-param name="namespace" select="$namespace" />
			</xsl:apply-templates>
		</xsl:element>
	</xsl:template>
	<xsl:template name="createLink" match="xsl:template[@name = 'createLink']" mode="dforms-a-button">
		<xsl:param name="namespace"/>
		<xsl:param name="view"/>
		<xsl:param name="model"/>
		<xsl:param name="desc"/>
		<xsl:attribute name="type">button</xsl:attribute>
		<xsl:attribute name="onclick">
			<xsl:if test="$view/d:attr[@name='onclick']">
				<xsl:call-template name="replace-string">
					<xsl:with-param name="text" select="$view/d:attr[@name='onclick']/@value"/>
					<xsl:with-param name="replace" select="'##namespace'"/>
					<xsl:with-param name="with" select="$namespace"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:text>window.location='</xsl:text>
			<xsl:call-template name="createActionURL">
				<xsl:with-param name="model" select="$model"/>
				<xsl:with-param name="view" select="$view"/>
			</xsl:call-template>
			<xsl:text>';</xsl:text>
		</xsl:attribute>
		<xsl:attribute name="value"><xsl:value-of select="$desc/@display-name"/></xsl:attribute>
	</xsl:template>
	<xsl:template name="createNewWindow" match="xsl:template[@name = 'createNewWindow']" mode="dforms-a-button">
		<xsl:param name="namespace"/>
		<xsl:param name="view"/>
		<xsl:param name="model"/>
		<xsl:param name="desc"/>
		<xsl:attribute name="type">button</xsl:attribute>
		<xsl:attribute name="onclick">
			<xsl:if test="$view/d:attr[@name='onclick']">
				<xsl:call-template name="replace-string">
					<xsl:with-param name="text" select="$view/d:attr[@name='onclick']/@value"/>
					<xsl:with-param name="replace" select="'##namespace'"/>
					<xsl:with-param name="with" select="$namespace"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:text>window.open('</xsl:text>
			<xsl:call-template name="createActionURL">
				<xsl:with-param name="model" select="$model"/>
				<xsl:with-param name="view" select="$view"/>
			</xsl:call-template>
			<xsl:variable name="window">
				<xsl:choose>
					<xsl:when test="$view/d:meta[@name='window']">
						<xsl:value-of select="$view/d:meta[@name='window']"/>
					</xsl:when>
					<xsl:otherwise>_BLANK</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:text>','</xsl:text>
			<xsl:value-of select="$window"/>
			<xsl:text>');</xsl:text>
		</xsl:attribute>
		<xsl:attribute name="value"><xsl:value-of select="$desc/@display-name"/></xsl:attribute>
	</xsl:template>
	<xsl:template name="createSubmit" match="xsl:template[@name = 'createSubmit']" mode="dforms-a-button">
		<xsl:param name="namespace"/>
		<xsl:param name="view"/>
		<xsl:param name="model"/>
		<xsl:param name="desc"/>
		<xsl:attribute name="type">submit</xsl:attribute>
		<xsl:if test="$model">
			<xsl:attribute name="onclick">
				<xsl:if test="$view/d:attr[@name='onclick']">
					<xsl:call-template name="replace-string">
						<xsl:with-param name="text" select="$view/d:attr[@name='onclick']/@value"/>
						<xsl:with-param name="replace" select="'##namespace'"/>
						<xsl:with-param name="with" select="$namespace"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:text>this.form.action='</xsl:text>
				<xsl:call-template name="createActionURL">
					<xsl:with-param name="model" select="$model"/>
					<xsl:with-param name="view" select="$view"/>
				</xsl:call-template>
				<xsl:text>';</xsl:text>
			</xsl:attribute>
		</xsl:if>
		<xsl:attribute name="value"><xsl:value-of select="$desc/@display-name"/></xsl:attribute>
	</xsl:template>
</xsl:stylesheet>