<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-a-link" match="*[contains(name(), 'link-action')]" mode="render">
		<xsl:param name="namespace" />
		<xsl:param name="locale" />
		<xsl:param name="view" select="." />
		<xsl:param name="model" />
		<xsl:param name="name" />
		<xsl:param name="id" />
		<xsl:variable name="type" select="$view/d:meta[@name='type']"/>
		<xsl:variable name="desc" select="d:desc[lang($locale) or not(@xml:lang)][1]"/>
		<xsl:variable name="actionURL">
			<xsl:call-template name="createActionURL">
				<xsl:with-param name="model" select="$model"/>
				<xsl:with-param name="view" select="$view"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:message>link action - $actionURL<xsl:value-of select="$actionURL"/></xsl:message>
		<xsl:element name="a">
			<xsl:choose>
				<xsl:when test="$type='window'">
					<xsl:attribute name="href"><xsl:value-of select="$actionURL"/></xsl:attribute>
					<xsl:variable name="window">
						<xsl:choose>
							<xsl:when test="$view/d:meta[@name='window']">
								<xsl:value-of select="$view/d:meta[@name='window']"/>
							</xsl:when>
							<xsl:otherwise>_BLANK</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:attribute name="target"><xsl:value-of select="$window"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="$type='submit'">
					<xsl:attribute name="href">javascript:this.form.action='<xsl:value-of select="$actionURL"/>';this.form.submit();</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="href"><xsl:value-of select="$actionURL"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:attribute name="class">dforms-a-link</xsl:attribute>
			<xsl:if test="$id!=''">
				<xsl:attribute name="id"><xsl:value-of select="concat($namespace,$view/@name)" /></xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="$view/d:desc/@short-desc" mode="add-title"/>
			<xsl:apply-templates select="d:attr" mode="add-attrs">
				<xsl:with-param name="namespace" select="$namespace" />
			</xsl:apply-templates>
			<xsl:if test="$desc/@icon">
				<img src="{$desc/@icon}" alt="$desc/@display-name" title="$desc/@short-desc"/>
			</xsl:if>
			<xsl:value-of select="$desc/@display-name"/>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>