<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:d="http://www.dforms.org/1.0">
	<xsl:import href="button/ButtonAction.xsl"/>
	<xsl:import href="link/LinkAction.xsl"/>
	<xsl:template name="renderAction" match="*[contains(name(),'-action')]" mode="x-render">
		<xsl:param name="namespace" /> 
		<xsl:param name="locale" /> 
		<xsl:param name="view" select="."/>
		<xsl:param name="model" />
		<xsl:param name="name"/>
		<xsl:param name="id"/>
		<xsl:param name="generated-name"/>
		<xsl:param name="generated-id"/>
		<xsl:param name="default-name"/>
		<xsl:param name="default-id"/>
		<xsl:param name="ignore-ns-prefix"/>
		<xsl:param name="disabled"/>
		<xsl:message>render action(<xsl:value-of select="name($view)"/>)</xsl:message>
		<xsl:apply-templates select="$view" mode="render">
			<xsl:with-param name="namespace" select="$namespace"/>
			<xsl:with-param name="locale" select="$locale"/>
			<xsl:with-param name="view" select="$view"/>
			<xsl:with-param name="model" select="$model"/>
			<xsl:with-param name="name" select="$name"/>
			<xsl:with-param name="id" select="$id"/>
			<xsl:with-param name="generated-name" select="$generated-name"/>
			<xsl:with-param name="generated-id" select="$generated-id"/>
			<xsl:with-param name="default-name" select="$default-name"/>
			<xsl:with-param name="default-id" select="$default-id"/>
			<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
			<xsl:with-param name="disabled" select="$disabled"/>
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template name="createActionURL" match="xsl:template[@name='createActionURL']" mode="dforms-a">
		<xsl:param name="model"/>
		<xsl:param name="view"/>
		<xsl:if test="boolean($model)">
			<xsl:value-of select="$model"/>
			<xsl:if test="count($model) > 1 and not(substring-before($model[1],'?'))">
				<xsl:text>?</xsl:text>
			</xsl:if>
			<xsl:for-each select="$model[position()>1]">
				<xsl:variable name="pos" select="position()"/>
				<xsl:text>&amp;</xsl:text>
				<xsl:choose>
					<xsl:when test="$view/d:ref[$pos + 1]/@name">
						<xsl:value-of select="$view/d:ref[$pos+1]/@name"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="local-name(.)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text>=</xsl:text>
				<xsl:value-of select="."/>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>