<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-c-contextHelp">
		<xsl:param name="namespace"/>
		<xsl:param name="view"/>
		<xsl:param name="name"/>
		<xsl:param name="id"/>
		<xsl:param name="locale"/>
		<xsl:variable name="desc" select="d:desc[lang($locale) or not(@xml:lang)][1]"/>
		<xsl:variable name="l10n-more">
			<xsl:choose>
				<xsl:when test="$locale='sk'">Viac k poľu </xsl:when>
				<xsl:otherwise>More about </xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:call-template name="dforms-c-ctrl">
			<xsl:with-param name="title" select="concat($l10n-more, $desc/@display-name, '...')"/>
			<xsl:with-param name="onclick">org.dforms.rk.ContextHelp.onContextHelp(event,'<xsl:value-of select="$id"/>help', '<xsl:value-of select="$locale"/>');</xsl:with-param>
			<xsl:with-param name="content" select="'?'"/>
		</xsl:call-template>
		<div id="{$id}help" style="display:none;position:absolute;" title="{$desc/@display-name}">
			<xsl:copy-of select="$desc/node()"/>
		</div>
	</xsl:template>
</xsl:stylesheet>