namespace("org.dforms.rk");
depends("org.dforms.dom");
depends("org.dforms.ui");
with(org.dforms.rk){
	org.dforms.rk.ContextHelp=function(event, locale, title, content){
		org.dforms.ui.Window.call(this, event.target||event.srcElement, 'contextHelp', locale, title);
		this.addContent(document.createTextNode(content));
		this.removeAllCtrl();
		this.addCtrl("\u00D7",this.dispose, this.rb.close);
		var style=this.impl.window.style;
		style.width="150px";
		style.height="104px";
		this.impl.style.left=ContextHelp.getPageX(event)+'px';
		this.impl.style.top=ContextHelp.getPageY(event)+'px';
	}
	ContextHelp.prototype=new org.dforms.ui.Window();
	ContextHelp.prototype.constructor=ContextHelp;
	ContextHelp.l10n={
			close:'Close'
	}
	ContextHelp.prototype.dispose=function(){
		var ctx=ContextHelp.instance;
		if(ctx){
			ctx.close();
		}
		ContextHelp.instance=null;
	}
	ContextHelp.onContextHelp=function(event, id, locale){
		var ctx=ContextHelp.instance;
		if(ctx){
			ctx.dispose();
		}
		var elm=document.getElementById(id);
		var title=elm.getAttribute('title');
		var content='';
		if(elm.childNodes.length>0){
			content=elm.childNodes[0].nodeValue;
		}
		ctx=ContextHelp.instance=new ContextHelp(event, locale, title, content);
		ctx.paint();
	};
	ContextHelp.getPageX=function(event){
		return event.pageX?event.pageX:event.clientX+document.body.scrollLeft+document.documentElement.scrollLeft;
	};
	ContextHelp.getPageY=function(event){
		return event.pageY?event.pageY:event.clientY+document.body.scrollTop+document.documentElement.scrollTop;
	};
}