<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-c-ctrl">
		<xsl:param name="title"/>
		<xsl:param name="onclick"/>
		<xsl:param name="class" select="'ctrl'"/>
		<xsl:param name="style"/>
		<xsl:param name="id"/>
		<xsl:param name="content"/>
		<xsl:element name="div">
			<xsl:attribute name="class"><xsl:value-of select="$class"/></xsl:attribute>
			<xsl:attribute name="title"><xsl:value-of select="$title"/></xsl:attribute>
			<xsl:attribute name="onclick"><xsl:value-of select="$onclick"/></xsl:attribute>
			<xsl:if test="$style">
				<xsl:attribute name="style"><xsl:value-of select="$style"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$id and $id != ''">
				<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
			</xsl:if>
			<xsl:element name="a">
				<xsl:attribute name="class">dforms-c-ctrl-link</xsl:attribute>
				<xsl:attribute name="href">#</xsl:attribute>
				<xsl:value-of select="$content"/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>