<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-c-grouper">
		<xsl:param name="namespace" />
		<xsl:param name="span" />
		<xsl:param name="group-by" />
		<xsl:param name="group-template"/>
		<xsl:param name="group-selector" />
		<xsl:param name="group-level" select="1"/>
    <tr class="dforms-d-group-{$group-level}" onclick="org.dforms.rk.Grouper.showHideGroup(this);" title="Zrolovať">
			<td colspan="{$span}">
				<xsl:call-template name="dforms-c-grouper-ident">
					<xsl:with-param name="level" select="$group-level - 1"/>
				</xsl:call-template>
				<xsl:call-template name="dforms-c-ctrl">
					<xsl:with-param name="class">ctrl dforms-c-grouper</xsl:with-param>
					<xsl:with-param name="content" select="'-'"/>
				</xsl:call-template>
   			<xsl:value-of select="$group-template[$group-level]"/>
   			<xsl:value-of select="$group-selector"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="dforms-c-grouper-ident">
		<xsl:param name="level" />
		<xsl:if test="$level > 0">
			<xsl:text>&#160;&#160;&#160;&#160;&#160;</xsl:text>
			<xsl:call-template name="dforms-c-grouper-ident">
				<xsl:with-param name="level" select="$level - 1"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>