<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template match="*[contains(@display-as,'dforms-c-grouper')]">
		<xsl:param name="namespace" />
		<xsl:param name="view" select="." />
		<xsl:param name="model" />
		<xsl:param name="name"/>
		<xsl:param name="locale" select="'en'"/>
		<xsl:param name="desc" select="d:desc[lang($locale) or not(@xml:lang)][1]"/>
		<xsl:param name="attr" select="$view/d:attr"/>
		<xsl:param name="ref" select="$view/d:ref"/>
		<xsl:attribute name="class">dforms-c-grouper</xsl:attribute>
		<xsl:if test="$attr">
			<xsl:apply-templates select="$attr" mode="add-attrs">
				<xsl:with-param name="namespace" select="$namespace" />
			</xsl:apply-templates>
		</xsl:if>
		<xsl:apply-templates select="$desc/@short-desc" mode="add-title"/>
		<xsl:value-of select="$desc/@short-desc"/>
	</xsl:template>
</xsl:stylesheet>