namespace("org.dforms.renderKit");
	org.dforms.renderKit.Grouper={};
	org.dforms.renderKit.Grouper.showHideGroup=function(cursor){
		if(Grouper.isCollapsed(cursor)){
			Grouper.setCollapsed(cursor, false);
			Grouper.showGroup(cursor);
		}else{
			Grouper.hideGroup(cursor);
			Grouper.setCollapsed(cursor, true);
		}
	}
	org.dforms.renderKit.Grouper.showGroup=function(cursor){
		var level=Grouper.getGroupLevel(cursor);
		var collapsed=Grouper.isCollapsed(cursor);
		cursor=cursor.nextSibling;
		var cursorLevel=Grouper.getGroupLevel(cursor);
		while(cursor !=null && (cursorLevel==null || cursorLevel>level)){
			if(!collapsed){
				if(document.all){
					cursor.style.display='';
				}else{
					cursor.style.visibility='';
				}
			}
			if(cursorLevel==null){
				cursor=cursor.nextSibling;
			}else{
				cursor=Grouper.showGroup(cursor);
			}
			cursorLevel=Grouper.getGroupLevel(cursor);
		}
		return cursor;
	}
	org.dforms.renderKit.Grouper.hideGroup=function(cursor){
		var level=Grouper.getGroupLevel(cursor);
		cursor=cursor.nextSibling;
		var cursorLevel=Grouper.getGroupLevel(cursor);
		while(cursor !=null && (cursorLevel==null || cursorLevel>level)){
			if(document.all){
				cursor.style.display='none';
			}else{
				cursor.style.visibility='collapse';
			}
			cursor=cursor.nextSibling;
			cursorLevel=Grouper.getGroupLevel(cursor);
		}
		return cursor;
	}
	org.dforms.renderKit.Grouper.isCollapsed=function(row){
		var ctrl=row.getElementsByTagName("div")[0];
		return ctrl.childNodes[0].nodeValue=="+";
	}
	org.dforms.renderKit.Grouper.setCollapsed=function(row, collapsed){
		var ctrl=row.getElementsByTagName("div")[0];
		while(ctrl.childNodes.length >0){
			ctrl.removeChild(ctrl.childNodes[0]);
		}
		ctrl.appendChild(document.createTextNode(collapsed?"+":"-"));
	}
	org.dforms.renderKit.Grouper.getGroupLevel=function(row){
		var ret=null;
		if(row){
			var clazz=row.className;
			var level=clazz.match(/dforms-d-group-(\d+)/);
			ret=level!=null?new Number(level[1]):null;
		}
		return ret;
	}
