<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-c-header">
		<xsl:param name="namespace" />
		<xsl:param name="view"/>
		<xsl:variable name="maxDepth">
			<xsl:for-each select=".//d:item">
				<xsl:sort select="count(ancestor::*)" data-type="number"/>
				 <xsl:if test="position()=last()">
				   <xsl:copy-of select="count(ancestor::*)"/>
			  </xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="minDepth" select="count(ancestor::*)"/>
		<xsl:call-template name="dforms-c-headerImp">
			<xsl:with-param name="namespace" select="$namespace"/>
			<xsl:with-param name="view" select="$view"/>
			<xsl:with-param name="depth" select="$minDepth + 1"/>
			<xsl:with-param name="minDepth" select="$minDepth"/>
			<xsl:with-param name="maxDepth" select="number($maxDepth)"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="dforms-c-headerImp">
		<xsl:param name="namespace" />
		<xsl:param name="view" select="."/>
		<xsl:param name="depth" />
		<xsl:param name="minDepth" />
		<xsl:param name="maxDepth" />
		<tr class="dforms-c-header dforms-c-header-{($depth - $minDepth)}">
			<xsl:if test="$depth = $minDepth + 1">
				<th rowspan="{$maxDepth - $depth + 1}"/>
			</xsl:if>
			<xsl:for-each select="$view//*[(local-name()='item' or local-name()='panel') and count(ancestor::*)=$depth]">
				<xsl:variable name="items" select=".//d:item"/>
				<xsl:element name="th">
					<xsl:if test="boolean(d:desc/@short-desc)">
						<xsl:attribute name="title"><xsl:value-of select="$view/d:desc/@short-desc" /></xsl:attribute>
					</xsl:if>
					<xsl:variable name="colspan" select="count($items)"/>
					<xsl:if test="$colspan > 1">
						<xsl:attribute name="colspan"><xsl:value-of select="$colspan"/></xsl:attribute>
					</xsl:if>
					<xsl:variable name="rowspan">
						<xsl:choose>
							<xsl:when test="$items">0</xsl:when>
							<xsl:otherwise><xsl:value-of  select="$maxDepth - $depth + 1"/></xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:if test="$rowspan > 1">
						<xsl:attribute name="rowspan"><xsl:value-of select="$rowspan"/></xsl:attribute>
					</xsl:if>
					<xsl:attribute name="scope">
						<xsl:choose>
							<xsl:when test="$items">colgroup</xsl:when>
							<xsl:otherwise>col</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
					<xsl:value-of select="d:desc/@display-name"/>
				</xsl:element>
			</xsl:for-each>
		</tr>
		<xsl:if test="$depth &lt; $maxDepth">
			<xsl:call-template name="dforms-c-headerImp">
				<xsl:with-param name="namespace" select="$namespace"/>
				<xsl:with-param name="view" select="$view"/>
				<xsl:with-param name="depth" select="$depth + 1"/>
				<xsl:with-param name="minDepth" select="$minDepth"/>
				<xsl:with-param name="maxDepth" select="$maxDepth"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>	
</xsl:stylesheet>