<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-c-menu">
		<xsl:param name="namespace" />
		<xsl:param name="view" />
		<xsl:param name="model" />
		<div class="dforms-c-menu">
			<span class="dforms-c-menu-item">
				<xsl:variable name="selected" select="$model/d:panel/d:item[@name='selected']"/>
				<xsl:for-each select="$view/d:action">
					<xsl:choose>
						<xsl:when test="$selected=@name">
							<xsl:value-of select="$view/d:desc/@display-name" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="dforms-a-link">
								<xsl:with-param name="namespace" select="$namespace"/>
								<xsl:with-param name="view" select="."/>
								<xsl:with-param name="model" select="$model"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:if test="position()!=last()">
						<span>|</span>
					</xsl:if>
				</xsl:for-each>
			</span>
		</div>
	</xsl:template>
</xsl:stylesheet>