<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-c-tab" match="*" mode="dforms-c-tab">
		<xsl:param name="namespace" />
		<xsl:param name="view" select="."/>
		<xsl:param name="position" select="1"/>
		<xsl:element name="div">
			<xsl:attribute name="onclick">onTab(event, '<xsl:value-of select="$namespace"/>', '<xsl:value-of select="$view/../@name"/>', '<xsl:value-of select="$view/@name"/>');</xsl:attribute>
			<xsl:attribute name="title"><xsl:value-of select="$view/d:desc/@short-desc"/></xsl:attribute>
			<xsl:choose>
				<xsl:when test="position()=1">
					<xsl:attribute name="class">dforms-p-tab-head-sel</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="class">dforms-p-tab-head</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="d:desc/@icon">
				<img src="{d:desc/@icon}" alt="{d:desc/@display-name}" title="{d:desc/@short-desc}"/>
			</xsl:if>
			<xsl:value-of select="$view/d:desc/@display-name"/>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>