<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://www.dforms.org/1.0"
	xmlns:m="http://www.dforms.org/messages/1.0">
	<xsl:template name="dforms-d-form" match="@name[.='dforms-d-form']" mode="render">
		<xsl:param name="namespace" />
		<xsl:param name="locale" />
		<xsl:param name="view"/>
		<xsl:param name="model" />
		<xsl:param name="name" />
		<xsl:param name="id" />
		<xsl:param name="generated-name" />
		<xsl:param name="generated-id" />
		<xsl:param name="default-name" />
		<xsl:param name="default-id" />
		<xsl:param name="ignore-ns-prefix"/>
		<xsl:param name="disabled" />
		<xsl:param name="content" />
		<xsl:element name="form">
			<xsl:attribute name="action"></xsl:attribute>
			<xsl:attribute name="method">post</xsl:attribute>
			<xsl:attribute name="class">dforms-d-form</xsl:attribute>
			<xsl:attribute name="onsubmit">return org.dforms.rk.Form.onFormSubmit(this);</xsl:attribute>
			<xsl:if test="$view/d:meta[@name='form.serialization']">
				<xsl:attribute name="enctype"><xsl:value-of select="$view/d:meta[@name='form.serialization']"/></xsl:attribute>
			</xsl:if>
			<div style="display:none;">
				<input type="hidden" name="xml" id="xml"/>
			</div>
			<div id="msgsg.{$id}">
				<xsl:apply-templates select="$model/ancestor-or-self::*//m:messages/m:global/m:message" mode="message"/>
			</div>
			<xsl:apply-templates select="$view" mode="decorate">
				<xsl:with-param name="namespace" select="$namespace" />
				<xsl:with-param name="locale" select="$locale" />
				<xsl:with-param name="view" select="$view" />
				<xsl:with-param name="model" select="$model" />
				<xsl:with-param name="name" select="$name" />
				<xsl:with-param name="id" select="$id" />
				<xsl:with-param name="generated-name" select="$generated-name" />
				<xsl:with-param name="generated-id" select="$generated-id" />
				<xsl:with-param name="default-name" select="$default-name" />
				<xsl:with-param name="default-id" select="$default-id" />
				<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
				<xsl:with-param name="disabled" select="$disabled"/>
				<xsl:with-param name="content" select="$content"/>
			</xsl:apply-templates>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>