namespace("org.dforms.rk");
depends("org.dforms.validation");
with(org.dforms.rk){
	org.dforms.rk.Form={};
	Form.onFormSubmit=function(form){
		var ret=false;
		var result=org.dforms.validation.Utils.validate(form);
		if(result.length==0){
			Form.disableActions(form);
			switch (form.enctype){
				case 'multipart/form-data':
				break;
				case 'application/xml':
					org.dforms.io.XMLHttpClient.post(Form.getActions(form), xml);	
				break;
				case 'application/x-www-form-urlencoded' :
				break;	
				case 'application/x-www-form-xmlencoded' :
					org.dforms.dom.DElement.parse(form);
					var hiddenbox = document.getElementById('xml');
					hiddenbox.value= org.dforms.dom.DElement.parse(form);
					form.appendChild(hiddenbox);
					Form.disableAll(form);
					form.enctype='application/x-www-form-urlencoded';
				break;
			}
			ret=true;
		}
		return ret;
	};
	Form.disableActions=function(form){
		for(var i=form.elements.length-1;i>=0;i--){
			try{
				var elm=form.elements[i];
				var elmName=elm.nodeName.toLowerCase();
				if(elmName=='button' || (elmName=='input' && (elm.type=='submit' || elm.type=='button'))){
					elm.disabled=true;
				}
			}catch(e){
			}
		}
	};
	Form.getActions=function(form){
		for(var i=form.elements.length-1;i>=0;i--){
			try{
				var elm=form.elements[i];
				var elmName=elm.nodeName.toLowerCase();
				if(elmName=='button' || (elmName=='input' && (elm.type=='submit' || elm.type=='button'))){
					elm.disabled=true;
				}
			}catch(e){
			}
		}
		return elm.value;
	};
	Form.disableAll=function(form){
		for(var i=form.elements.length-1;i>=0;i--){
			try{
				var elm=form.elements[i];
				var elmName=elm.nodeName.toLowerCase();
				if(!(elm.type=='hidden')){
					elm.disabled=true;
				}
			}catch(e){
			}
		}
	};
}