<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-d-itemset" match="@name[.='dforms-d-itemset']" mode="render">
		<xsl:param name="namespace" />
		<xsl:param name="locale" />
		<xsl:param name="view" select="."/>
		<xsl:param name="model" />
		<xsl:param name="name" />
		<xsl:param name="id" />
		<xsl:param name="generated-name" />
		<xsl:param name="generated-id" />
		<xsl:param name="default-name"/>
		<xsl:param name="default-id"/>
		<xsl:param name="ignore-ns-prefix"/>
		<xsl:param name="disabled" />
		<xsl:param name="content" />
		<xsl:element name="fieldset">
			<xsl:attribute name="class">dforms-d-fieldset</xsl:attribute>
			<xsl:variable name="desc" select="$view/d:desc[lang($locale) or not(@xml:lang)][1]"/>
			<xsl:if test="$desc/@short-desc">
				<xsl:attribute name="title"><xsl:value-of select="$desc/@short-desc"/></xsl:attribute>
			</xsl:if>
			<legend><xsl:value-of select="$desc/@display-name"/></legend>
			<xsl:apply-templates select="$view" mode="decorate">
				<xsl:with-param name="namespace" select="$namespace" />
				<xsl:with-param name="locale" select="$locale" />
				<xsl:with-param name="view" select="$view" />
				<xsl:with-param name="model" select="$model" />
				<xsl:with-param name="name" select="$name" />
				<xsl:with-param name="id" select="$id" />
				<xsl:with-param name="generated-name" select="$generated-name" />
				<xsl:with-param name="generated-id" select="$generated-id" />
				<xsl:with-param name="default-name" select="$default-name" />
				<xsl:with-param name="default-id" select="$default-id" />
				<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
				<xsl:with-param name="disabled" select="$disabled"/>
				<xsl:with-param name="content" select="$content"/>
			</xsl:apply-templates>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>