<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:v="http://www.dforms.org/validation/1.0"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-d-multi" match="@name[.='dforms-d-multi']" mode="render">
		<xsl:param name="namespace" />
		<xsl:param name="locale" />
		<xsl:param name="view" select="."/>
		<xsl:param name="model" />
		<xsl:param name="name" />
		<xsl:param name="id" />
		<xsl:param name="generated-name" />
		<xsl:param name="generated-id" />
		<xsl:param name="default-name"/>
		<xsl:param name="default-id"/>
		<xsl:param name="ignore-ns-prefix"/>
		<xsl:param name="disabled"/>
		<xsl:param name="content" />
		<xsl:variable name="ordered" select="$view/d:meta[@name='dforms-d-multi-ordered']='true'"/>
		<xsl:variable name="mutable" select="not($view/d:meta[@name='dforms-d-multi-mutable']='false')"/>
		<xsl:variable name="desc" select="$view/d:desc[lang($locale) or not(@xml:lang)][1]"/>
		
		<div class="dforms-d-multi">
			<xsl:attribute name="v:onSuccess">org.dforms.rk.Multi.onSuccess(element, event);</xsl:attribute>
			<xsl:attribute name="v:onFailure">org.dforms.rk.Multi.onFailure(element, event);</xsl:attribute>
			<xsl:attribute name="v:onChildSuccess">org.dforms.rk.Multi.onChildSuccess(element, event);</xsl:attribute>
			<xsl:attribute name="v:onChildFailure">org.dforms.rk.Multi.onChildFailure(element, event);</xsl:attribute>
			<xsl:if test="$mutable">
				<div id="{$id}-template" style="display:none;">
					<table>
						<tbody>
							<tr>
								<td>
									<xsl:call-template name="renderDecoratorImp">
										<xsl:with-param name="namespace" select="$namespace"/>
										<xsl:with-param name="locale" select="$locale"/>
										<xsl:with-param name="view" select="$view"/>
										<xsl:with-param name="name" select="concat($name,'[0]')" />
										<xsl:with-param name="id" select="concat($id,'.0.')" />
										<xsl:with-param name="generated-name" select="concat($generated-name,'[0]')" />
										<xsl:with-param name="generated-id" select="concat($generated-id,'.0.')" />
										<xsl:with-param name="default-name" select="$default-name" />
										<xsl:with-param name="default-id" select="$default-id" />
										<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
										<xsl:with-param name="disabled" select="$disabled"/>
										<xsl:with-param name="content" select="$content"/>
									</xsl:call-template>
								</td>
								<td>
									<xsl:if test="$ordered">
										<xsl:call-template name="dforms-d-multi-up">
											<xsl:with-param name="locale" select="$locale"/>
											<xsl:with-param name="desc" select="$desc"/>
										</xsl:call-template>
										<xsl:call-template name="dforms-d-multi-down">
											<xsl:with-param name="locale" select="$locale"/>
											<xsl:with-param name="desc" select="$desc"/>
										</xsl:call-template>
									</xsl:if>
									<xsl:call-template name="dforms-d-multi-remove">
											<xsl:with-param name="locale" select="$locale"/>
											<xsl:with-param name="desc" select="$desc"/>
										</xsl:call-template>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
			</xsl:if>
			<div id="{$id}-container">
				<xsl:choose>
					<xsl:when test="$model">
						<xsl:for-each select="$model">
							<table>
								<tbody>
									<tr>
										<td>
											<xsl:call-template name="renderDecoratorImp">
												<xsl:with-param name="namespace" select="$namespace"/>
												<xsl:with-param name="locale" select="$locale"/>
												<xsl:with-param name="view" select="$view"/>
												<xsl:with-param name="model" select="."/>
												<xsl:with-param name="name" select="concat($name,'[',position(),']')" />
												<xsl:with-param name="id" select="concat($id,'.',position(),'.')" />
												<xsl:with-param name="generated-name" select="concat($generated-name,'[',position(),']')"/>
												<xsl:with-param name="generated-id" select="concat($generated-id,'.',position(),'.')"/>
												<xsl:with-param name="default-name" select="$default-name" />
												<xsl:with-param name="default-id" select="$default-id" />
												<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
												<xsl:with-param name="disabled" select="$disabled"/>
												<xsl:with-param name="content" select="$content"/>
											</xsl:call-template>
										</td>
										<td>
											<xsl:if test="$mutable">
												<xsl:if test="$ordered">
													<xsl:call-template name="dforms-d-multi-up">
														<xsl:with-param name="locale" select="$locale"/>
														<xsl:with-param name="desc" select="$desc"/>
													</xsl:call-template>
													<xsl:call-template name="dforms-d-multi-down">
														<xsl:with-param name="locale" select="$locale"/>
														<xsl:with-param name="desc" select="$desc"/>
													</xsl:call-template>
												</xsl:if>
												<xsl:call-template name="dforms-d-multi-remove">
													<xsl:with-param name="locale" select="$locale"/>
													<xsl:with-param name="desc" select="$desc"/>
												</xsl:call-template>
											</xsl:if>
										</td>
									</tr>
								</tbody>
							</table>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
							<table>
								<tbody>
									<tr>
										<td>
											<xsl:call-template name="renderDecoratorImp">
												<xsl:with-param name="namespace" select="$namespace"/>
												<xsl:with-param name="locale" select="$locale"/>
												<xsl:with-param name="view" select="$view"/>
												<xsl:with-param name="model" select="$model"/>
												<xsl:with-param name="name" select="concat($name,'[1]')" />
												<xsl:with-param name="id" select="concat($id,'.1.')" />
												<xsl:with-param name="generated-name" select="concat($generated-name,'[1]')"/>
												<xsl:with-param name="generated-id" select="concat($generated-id,'.1.')"/>
												<xsl:with-param name="default-name" select="$default-name" />
												<xsl:with-param name="default-id" select="$default-id" />
												<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
												<xsl:with-param name="disabled" select="$disabled"/>
												<xsl:with-param name="content" select="$content"/>
											</xsl:call-template>
										</td>
										<td>
											<xsl:if test="$mutable">
												<xsl:if test="$ordered">
													<xsl:call-template name="dforms-d-multi-up">
														<xsl:with-param name="locale" select="$locale"/>
														<xsl:with-param name="desc" select="$desc"/>
													</xsl:call-template>
													<xsl:call-template name="dforms-d-multi-down">
														<xsl:with-param name="locale" select="$locale"/>
														<xsl:with-param name="desc" select="$desc"/>
													</xsl:call-template>
												</xsl:if>
												<xsl:call-template name="dforms-d-multi-remove">
													<xsl:with-param name="locale" select="$locale"/>
													<xsl:with-param name="desc" select="$desc"/>
												</xsl:call-template>
											</xsl:if>
										</td>
									</tr>
								</tbody>
							</table>
					</xsl:otherwise>
				</xsl:choose>
			</div>
			<xsl:if test="$mutable">
				<xsl:call-template name="dforms-d-multi-add">
					<xsl:with-param name="namespace" select="$namespace"/>
					<xsl:with-param name="locale" select="$locale"/>
					<xsl:with-param name="name" select="$name"/>
					<xsl:with-param name="id" select="$id"/>
					<xsl:with-param name="desc" select="$desc"/>
				</xsl:call-template>
			</xsl:if>
		</div>
	</xsl:template>
	<xsl:template name="dforms-d-multi-remove">
		<xsl:param name="locale"/>
		<xsl:param name="desc"/>
		<xsl:variable name="l10n-remove">
			<xsl:choose>
				<xsl:when test="$locale='sk'">Odstráň pole </xsl:when>
				<xsl:otherwise>Remove </xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:call-template name="dforms-c-ctrl">
			<xsl:with-param name="title" select="concat($l10n-remove,$desc/@display-name)"/>
			<xsl:with-param name="onclick">org.dforms.rk.Multi.removeEditor(this);return false;</xsl:with-param>
			<xsl:with-param name="content" select="'&#x00D7;'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="dforms-d-multi-up">
		<xsl:param name="locale"/>
		<xsl:param name="desc"/>
		<xsl:variable name="l10n-up">
			<xsl:choose>
				<xsl:when test="$locale='sk'">Posuň nahor </xsl:when>
				<xsl:otherwise>Move up </xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:call-template name="dforms-c-ctrl">
			<xsl:with-param name="title" select="concat($l10n-up,$desc/@display-name)"/>
			<xsl:with-param name="onclick">org.dforms.rk.Multi.moveUp(this);return false;</xsl:with-param>
			<xsl:with-param name="content" select="'&#x5E;'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="dforms-d-multi-down">
		<xsl:param name="locale"/>
		<xsl:param name="desc"/>
		<xsl:variable name="l10n-down">
			<xsl:choose>
				<xsl:when test="$locale='sk'">Posuň nadol </xsl:when>
				<xsl:otherwise>Move down </xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:call-template name="dforms-c-ctrl">
			<xsl:with-param name="title" select="concat($l10n-down,$desc/@display-name)"/>
			<xsl:with-param name="onclick">org.dforms.rk.Multi.moveDown(this);return false;</xsl:with-param>
			<xsl:with-param name="content" select="'v'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="dforms-d-multi-add">
		<xsl:param name="namespace"/>
		<xsl:param name="locale"/>
		<xsl:param name="desc"/>
		<xsl:param name="name"/>
		<xsl:param name="id"/>
		<xsl:param name="l10n"/>
		<xsl:variable name="l10n-add">
			<xsl:choose>
				<xsl:when test="$locale='sk'">Pridať</xsl:when>
				<xsl:otherwise>Add</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<input type="button" class="dforms-d-multi-add" onclick="org.dforms.rk.Multi.addEditor('{$namespace}', '{$name}', '{$id}');return false;" value="{$l10n-add}" title="{$l10n-add} {$desc/@display-name}"/>
	</xsl:template>
</xsl:stylesheet>