namespace("org.dforms.rk");
depends("org.dforms.dom");
depends("org.dforms.validation");
with(org.dforms.rk){
	org.dforms.rk.Multi={};
	Multi.onChildFailure= function(panel, event){
		var id=event.source.id;
		var msgs=document.getElementById("msgs." + id);
		if(!msgs){
			var tr=org.dforms.dom.Document.createElementNS("http://www.w3.org/1999/xhtml", "tr");
			msgs=org.dforms.dom.Document.createElementNS("http://www.w3.org/1999/xhtml", "td");
			msgs.setAttribute("id", "msgs." + id);
			msgs.setAttribute("colspan", 2);
			tr.appendChild(msgs);
			var row=event.source.parentNode.parentNode;
			row.parentNode.insertBefore(tr, row);
		}
		msgs.parentNode.style.display="none";
		with(org.dforms.validation){
			Utils.clearMessages(msgs);
			Utils.showMessages(msgs, event.messages);
		}
		msgs.parentNode.style.display="";
	}
	Multi.onChildSuccess=function(panel, event){
		var id=event.source.id;
		var msgs=document.getElementById("msgs." + id);
		if(msgs){
			msgs.parentNode.style.display="none";
			with(org.dforms.validation){
				Utils.clearMessages(msgs);
				Utils.unhighlightLabel(id);
			}
		}
	}
	Multi.onSuccess=function(panel, event){
		with(org.dforms.validation){
			Event.fireEvent(new ChildSuccessEvent(event.context), event.context.parent);
		}
	}
	Multi.onFailure=function(panel, event){
		with(org.dforms.validation){
			Event.fireEvent(new ChildFailureEvent(event.context, []), event.context.parent);
		}
	};
	Multi.removeEditor= function(button){
		var row=button.parentNode.parentNode.parentNode.parentNode;
		row.parentNode.removeChild(row);
	};
	Multi.addEditor=function(namespace, editorName, editorID){
		var container=document.getElementById(editorID + "-container");
		var template=document.getElementById(editorID + "-template");
		var templateEditor=Multi.getTemplateEditor(template);
		var newEditor=templateEditor.cloneNode(true);
		var position=Multi.getEditorsCount(container) + 1;
		Multi.replaceID(newEditor, editorID, 0, position);
		Multi.replaceName(newEditor, editorName, position);
		Multi.setEnabled(newEditor, true);
		container.appendChild(newEditor);
		return newEditor;
	};
	Multi.moveUp=function(button){
		var row=button.parentNode.parentNode.parentNode.parentNode;
		var sibling=row.previousSibling;
		if(sibling != null){
			var id=row.parentNode.id;
			id=id.substring(0, id.indexOf("-container"));
			var name=Multi.nameFromId(id);
			var position=Multi.getPosition(sibling);
			Multi.replaceName(row, name, position);
			Multi.replaceName(sibling, name, position+1);
			Multi.replaceID(row, id, position+1, position);
			Multi.replaceID(sibling, id, position, position+1);
			row.parentNode.insertBefore(row, sibling);
		}
	};
	Multi.moveDown=function(button){
		var row=button.parentNode.parentNode.parentNode.parentNode;
		var sibling=row.nextSibling;
		if(sibling != null){
			var id=row.parentNode.id;
			id=id.substring(0, id.indexOf("-container"));
			var name=Multi.nameFromId(id);
			var position=Multi.getPosition(sibling);
			Multi.replaceName(row, name, position);
			Multi.replaceName(sibling, name, position-1);
			Multi.replaceID(row, id, position-1, position);
			Multi.replaceID(sibling, id, position, position-1);
			sibling=sibling.nextSibling;
			if(sibling == null){
				row.parentNode.appendChild(row);
			}else{
				row.parentNode.insertBefore(row, sibling);
			}
		}
	};
	Multi.nameFromId=function(id){
		var ret=id.substring(id.indexOf('.'));
		ret=ret.replace(/\.(\d+)\.\./g,"[$1]/")
		ret=ret.replace(/\./g,'/');
		return ret;
	}
	Multi.getPosition=function(table){
		var childNodes=table.parentNode.childNodes;
		for(var i=0;i<childNodes.length;i++){
			var child=childNodes[i];
			if(child==table){
				return i+1;
			}
		}
		return -1;
	}
	Multi.getEditorsCount=function(container){
		var ret=0;
		var size=container.childNodes.length;
		for( var i=0; i < size; i++){
			var node=container.childNodes[i];
			if(node.nodeType == 1 && node.nodeName.toLowerCase() == 'table'){ // element
																																				// node
				ret++;
			}
		}
		return ret;
	};
	Multi.replaceID=function(element, id, oldPos, newPos){
		try{
			var elm=element;
			var attrs=["id", "onclick", "onchange", "for" ];
			for( var i=0; i < attrs.length; i++){
				var name=attrs[i];
				var value=elm.getAttribute(name);
				if(value != null && value != ""){
					value=value.toString();
					var rep="" + Multi.normalizeEventHandler(value);
					var regexp=new RegExp("(" + id + ")\."+oldPos+"\.", "g");
					if(rep.match(regexp)){
						rep=rep.replace(regexp, "$1." + newPos + ".");
						if(value.indexOf("function") == 0){
							rep=new Function(rep);
						}
						elm.setAttribute(name, rep);
					}
				}
			}
			var size=elm.childNodes.length;
			for( var i=0; i < size; i++){
				var node=elm.childNodes[i];
				if(node.nodeType == 1){ // element node
					Multi.replaceID(node, id, oldPos, newPos);
				}
			}
		}catch(e){
			alert(id + ": " + e);
		}
	};
	Multi.escapeName= function(name){
		return name.replace(/([\[\]])/g, "\\$1");
	};
	Multi.replaceName= function(element, name, position){
		try{
			var attrs=["name", "onclick" ];
			for( var i=0; i < attrs.length; i++){
				var value=element.getAttribute(attrs[i]);
				if(value != null && value != ""){
					value=value.toString();
					var rep="" + Multi.normalizeEventHandler(value);
					var regexp=new RegExp("(" + Multi.escapeName(name) + ")\\[\\d+\\]", "g");
					if(rep.match(regexp)){
						rep=rep.replace(regexp, name + "[" + position + "]");
						if(value.indexOf("function") == 0){
							rep=new Function(rep);
						}
						element.setAttribute(attrs[i], rep);
					}
				}
			}
			var size=element.childNodes.length;
			for( var i=0; i < size; i++){
				var node=element.childNodes[i];
				if(node.nodeType == 1){ // element node
					Multi.replaceName(node, name, position);
				}
			}
		}catch(e){
			alert(e.name + ": " + e.message);
		}
	};
	/**
	 * Workaround to the lack of DOM support in IE. Element.getAttribute(name)
	 * returns reference to funcion rather than attribute value. So, we must strip
	 * leading ("function anonymous..") and trailing stuff. If possible, avoid
	 * using IE.
	 */
	Multi.normalizeEventHandler= function(handler){
		var ret="" + handler;
		if(ret.indexOf("function") == 0){
			ret=ret.substring(23, ret.length - 2);
		}
		return ret;
	};
	Multi.setEnabled= function(container, enabled){
		if(container.className.indexOf('dforms-p-combo')!=-1){
			var id=container.id+'combo1';
			var pane=Multi.getElementById(container, id);
			Combo.showCombo(pane);
			return;
		}
		if(container.nodeName.toLowerCase() == 'input' || container.nodeName.toLowerCase() == 'textarea'
		    || container.nodeName.toLowerCase() == 'select'){
			container.removeAttribute("disabled");
			return;
		}
		var size=container.childNodes.length;
		for( var i=0; i < size; i++){
			var node=container.childNodes[i];
			if(node.nodeType == 1){ // element node
				var id=node.getAttribute('id');
				if(id == null || id.lastIndexOf("-template") == -1){
					Multi.setEnabled(node, enabled);
				}
			}
		}
	};
	Multi.getElementById=function(ctx, id){
		var ret=null;
		if(ctx.id==id){
			ret=ctx;
		}else{
			var childNodes=ctx.childNodes;
			for(var i=0;i<childNodes.length;i++){
				var node=childNodes[i];
				if(node.nodeType==1){
					ret=Multi.getElementById(node,id);
					if(ret!=null){
						break;
					}
				}
			}
		}
		return ret;
	}
	Multi.getTemplateEditor= function(elm){
		var size=elm.childNodes.length;
		for( var i=0; i < size; i++){
			var node=elm.childNodes[i];
			if(node.nodeType == 1){ // element node
				return node;
			}
		}
		return elm;
	};
}