<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/1999/xhtml"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:import href="form/FormDecorator.xsl" />
	<xsl:import href="multi/MultiDecorator.xsl" />
	<xsl:import href="itemset/ItemsetDecorator.xsl" />
	<!--  
	<xsl:import href="repeat/RepeatDecorator.xsl" />
	<xsl:import href="group/GroupDecorator.xsl" />
	<xsl:import href="tree/InnerNodeDecorator.xsl" />
	-->
	<xsl:template name="renderDecorator" match="*[@display-as]" mode="x-render">
		<xsl:param name="namespace" />
		<xsl:param name="locale" />
		<xsl:param name="view" select="." />
		<xsl:param name="model" />
		<xsl:param name="name"/>
		<xsl:param name="id"/>
		<xsl:param name="generated-name"/>
		<xsl:param name="generated-id"/>
		<xsl:param name="default-name"/>
		<xsl:param name="default-id"/>
		<xsl:param name="ignore-ns-prefix"/>
		<xsl:param name="disabled"/>
		<xsl:apply-templates select="$view" mode="decorate">
			<xsl:with-param name="namespace" select="$namespace" />
			<xsl:with-param name="locale" select="$locale" />
			<xsl:with-param name="view" select="$view" />
			<xsl:with-param name="model" select="$model" />
			<xsl:with-param name="name" select="$name"/>
			<xsl:with-param name="id" select="$id"/>
			<xsl:with-param name="generated-name" select="$generated-name" />
			<xsl:with-param name="generated-id" select="$generated-id" />
			<xsl:with-param name="default-name" select="$default-name" />
			<xsl:with-param name="default-id" select="$default-id" />
			<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
			<xsl:with-param name="disabled" select="$disabled"/>
			<xsl:with-param name="content" select="$view/@display-as"/>
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template name="renderDecoratorImp" match="*" mode="decorate">
		<xsl:param name="namespace" />
		<xsl:param name="locale" />
		<xsl:param name="view" select="."/>
		<xsl:param name="model" />
		<xsl:param name="name"/>
		<xsl:param name="id"/>
		<xsl:param name="generated-name"/>
		<xsl:param name="generated-id"/>
		<xsl:param name="default-name"/>
		<xsl:param name="default-id"/>
		<xsl:param name="ignore-ns-prefix"/>
		<xsl:param name="disabled"/>
		<xsl:param name="content"/>
		<xsl:variable name="decorator">
			<xsl:choose>
				<xsl:when test="contains($content,' ')">
					<xsl:value-of select="substring-before($content, ' ')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$content"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:message>string-length($decorator)<xsl:value-of select="string-length($decorator)"/></xsl:message>
		<xsl:choose>
			<xsl:when test="string-length($decorator)>0">
				<xsl:choose>
					<xsl:when test="$decorator = 'dforms-d-multi'">
						<xsl:call-template name="dforms-d-multi">
							<xsl:with-param name="namespace" select="$namespace" />
							<xsl:with-param name="locale" select="$locale" />
							<xsl:with-param name="view" select="$view" />
							<xsl:with-param name="model" select="$model" />
							<xsl:with-param name="name" select="$name" />
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="generated-name" select="$generated-name" />
							<xsl:with-param name="generated-id" select="$generated-id" />
							<xsl:with-param name="default-name" select="$default-name" />
							<xsl:with-param name="default-id" select="$default-id" />
							<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
							<xsl:with-param name="disabled" select="$disabled"/>
							<xsl:with-param name="content" select="substring-after($content, ' ')" />
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$decorator = 'dforms-d-itemset'">
						<xsl:call-template name="dforms-d-itemset">
							<xsl:with-param name="namespace" select="$namespace" />
							<xsl:with-param name="locale" select="$locale" />
							<xsl:with-param name="view" select="$view" />
							<xsl:with-param name="model" select="$model" />
							<xsl:with-param name="name" select="$name" />
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="generated-name" select="$generated-name" />
							<xsl:with-param name="generated-id" select="$generated-id" />
							<xsl:with-param name="default-name" select="$default-name" />
							<xsl:with-param name="default-id" select="$default-id" />
							<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
							<xsl:with-param name="disabled" select="$disabled"/>
							<xsl:with-param name="content" select="substring-after($content, ' ')" />
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$decorator = 'dforms-d-form'">
						<xsl:call-template name="dforms-d-form">
							<xsl:with-param name="namespace" select="$namespace" />
							<xsl:with-param name="locale" select="$locale" />
							<xsl:with-param name="view" select="$view" />
							<xsl:with-param name="model" select="$model" />
							<xsl:with-param name="name" select="$name" />
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="generated-name" select="$generated-name" />
							<xsl:with-param name="generated-id" select="$generated-id" />
							<xsl:with-param name="default-name" select="$default-name" />
							<xsl:with-param name="default-id" select="$default-id" />
							<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
							<xsl:with-param name="disabled" select="$disabled"/>
							<xsl:with-param name="content" select="substring-after($content, ' ')" />
						</xsl:call-template>
					</xsl:when>
					<!-- 
					<xsl:when test="$decorator = 'dforms-d-repeat'">
						<xsl:call-template name="dforms-d-repeat">
							<xsl:with-param name="namespace" select="$namespace" />
							<xsl:with-param name="locale" select="$locale" />
							<xsl:with-param name="view" select="$view" />
							<xsl:with-param name="model" select="$model" />
							<xsl:with-param name="name" select="$name" />
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="generated-name" select="$generated-name" />
							<xsl:with-param name="generated-id" select="$generated-id" />
							<xsl:with-param name="default-name" select="$default-name" />
							<xsl:with-param name="default-id" select="$default-id" />
							<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
							<xsl:with-param name="disabled" select="$disabled"/>
							<xsl:with-param name="content" select="substring-after($content, ' ')" />
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$decorator = 'dforms-d-group'">
						<xsl:call-template name="dforms-d-group">
							<xsl:with-param name="namespace" select="$namespace" />
							<xsl:with-param name="locale" select="$locale" />
							<xsl:with-param name="view" select="$view" />
							<xsl:with-param name="model" select="$model" />
							<xsl:with-param name="name" select="$name" />
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="generated-name" select="$generated-name" />
							<xsl:with-param name="generated-id" select="$generated-id" />
							<xsl:with-param name="default-name" select="$default-name" />
							<xsl:with-param name="default-id" select="$default-id" />
							<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
							<xsl:with-param name="disabled" select="$disabled"/>
							<xsl:with-param name="content" select="substring-after($content, ' ')" />
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$decorator = 'dforms-d-tree-innerNode'">
						<xsl:call-template name="dforms-d-tree-innerNode">
							<xsl:with-param name="namespace" select="$namespace" />
							<xsl:with-param name="locale" select="$locale" />
							<xsl:with-param name="view" select="$view" />
							<xsl:with-param name="model" select="$model" />
							<xsl:with-param name="name" select="$name" />
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="generated-name" select="$generated-name" />
							<xsl:with-param name="generated-id" select="$generated-id" />
							<xsl:with-param name="default-name" select="$default-name" />
							<xsl:with-param name="default-id" select="$default-id" />
							<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
							<xsl:with-param name="disabled" select="$disabled"/>
							<xsl:with-param name="content" select="substring-after($content, ' ')" />
						</xsl:call-template>
					</xsl:when>
					 -->
					<xsl:otherwise>
						<xsl:apply-templates select="$view" mode="decorate">
							<xsl:with-param name="namespace" select="$namespace" />
							<xsl:with-param name="locale" select="$locale" />
							<xsl:with-param name="view" select="$view" />
							<xsl:with-param name="model" select="$model" />
							<xsl:with-param name="name" select="$name" />
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="generated-name" select="$generated-name" />
							<xsl:with-param name="generated-id" select="$generated-id" />
							<xsl:with-param name="default-name" select="$default-name" />
							<xsl:with-param name="default-id" select="$default-id" />
							<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
							<xsl:with-param name="disabled" select="$disabled"/>
							<xsl:with-param name="content" select="substring-after($content, ' ')"/>
						</xsl:apply-templates>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="$view" mode="render">
					<xsl:with-param name="namespace" select="$namespace" />
					<xsl:with-param name="locale" select="$locale" />
					<xsl:with-param name="view" select="$view" />
					<xsl:with-param name="model" select="$model" />
					<xsl:with-param name="name" select="$name"/>
					<xsl:with-param name="id" select="$id"/>
					<xsl:with-param name="generated-name" select="$generated-name" />
					<xsl:with-param name="generated-id" select="$generated-id" />
					<xsl:with-param name="default-name" select="$default-name" />
					<xsl:with-param name="default-id" select="$default-id" />
					<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
					<xsl:with-param name="disabled" select="$disabled"/>
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>