<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-e-area" match="*[contains(name(),'area-editor')]" mode="render">
		<xsl:param name="namespace" />
		<xsl:param name="view" select="." />
		<xsl:param name="model" />
		<xsl:param name="name"/>
		<xsl:param name="id"/>
		<xsl:param name="locale" select="'en'"/>
		<xsl:param name="desc" select="d:desc[lang($locale) or not(@xml:lang)][1]"/>
		<xsl:param name="attr" select="$view/d:attr"/>
		<xsl:param name="ref" select="$view/d:ref"/>
		<xsl:element name="textarea">
			<xsl:attribute name="type">text</xsl:attribute>
			<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
			<xsl:attribute name="class">dforms-e-area</xsl:attribute>
			<xsl:if test="$id != ''">
				<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="$desc/@short-desc" mode="add-title"/>
			<!-- add attributes -->
			<xsl:apply-templates select="$attr" mode="add-attrs">
				<xsl:with-param name="namespace" select="$namespace" />
			</xsl:apply-templates>
			<!-- add validation attributes -->
			<xsl:apply-templates select="$ref/@*" mode="add-v-attributes"/>
			<xsl:choose>
				<xsl:when test="contains($name,'[0')">
					<xsl:attribute name="disabled">disabled</xsl:attribute>
				</xsl:when>
				<xsl:when test="$model">
					<xsl:value-of select="$model" />
				</xsl:when>
			</xsl:choose>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>