<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" 
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:v="http://www.dforms.org/validation/1.0"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-e-checkbox" match="*[contains(name(),'checkbox-editor')]" mode="render">
		<xsl:param name="namespace" />
		<xsl:param name="locale"/>
		<xsl:param name="view" select="." />
		<xsl:param name="model" />
		<xsl:param name="name"/>
		<xsl:param name="id"/>
		<xsl:param name="disabled"/>
		<xsl:param name="desc" select="d:desc[lang($locale) or not(@xml:lang)][1]"/>
		<xsl:param name="attr" select="$view/d:attr"/>
		<xsl:param name="ref" select="$view/d:ref"/>
		<span style="display:table-cell;">
			<xsl:element name="input">
				<xsl:attribute name="type">checkbox</xsl:attribute>
				<xsl:attribute name="class">dforms-e-checkbox</xsl:attribute>
				<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
				<xsl:attribute name="value">true</xsl:attribute>
				<xsl:if test="$id != ''">
					<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="$disabled">
					<xsl:attribute name="disabled">disabled</xsl:attribute>
				</xsl:if>
				<xsl:apply-templates select="$desc/@short-desc" mode="add-title"/>
				<xsl:choose>
					<xsl:when test="contains($name,'[0')">
						<xsl:attribute name="disabled">disabled</xsl:attribute>
					</xsl:when>
					<xsl:when test="$model='true'">
						<xsl:attribute name="checked">checked</xsl:attribute>
					</xsl:when>
				</xsl:choose>
				<!-- add attributes do not remove 'if' - IE shit -->
				<xsl:if test="$attr">
					<xsl:apply-templates select="$attr" mode="add-attrs">
						<xsl:with-param name="namespace" select="$namespace" />
					</xsl:apply-templates>
				</xsl:if>
				<!-- add validation attributes -->
				<xsl:apply-templates select="$ref/@*" mode="add-v-attributes"/>
			</xsl:element>
		</span>
		<xsl:if test="$desc/@short-desc">
			<xsl:element name="label">
				<xsl:if test="$id != ''">
					<xsl:attribute name="for"><xsl:value-of select="$id"/></xsl:attribute>
				</xsl:if>
				<xsl:attribute name="class">description</xsl:attribute>
				<xsl:value-of select="$desc/@short-desc"/>
			</xsl:element>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>