<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-e-combo" match="*[contains(name(),'combo-editor')]" mode="render">
		<xsl:param name="namespace" />
		<xsl:param name="locale"/>
		<xsl:param name="view" select="." />
		<xsl:param name="model" />
		<xsl:param name="name"/>
		<xsl:param name="default-name" />
		<xsl:param name="id" />
		<xsl:param name="default-id" />
		<xsl:param name="ignore-ns-prefix" />
		<xsl:param name="disabled" />
		<xsl:param name="desc" select="$view/d:desc[lang($locale) or not(@xml:lang)][1]"/>
		<xsl:param name="attr" select="$view/d:attr"/>
		<xsl:param name="ref" select="$view/d:ref"/>
		<xsl:element name="select">
			<xsl:attribute name="class">dforms-e-combo</xsl:attribute>
			<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
			<xsl:if test="$id != ''">
				<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="$desc/@short-desc" mode="add-title"/>
			<xsl:choose>
				<xsl:when test="contains($name,'[0')">
					<xsl:attribute name="disabled">disabled</xsl:attribute>
				</xsl:when>
			</xsl:choose>
			<!-- add attributes -->
			<xsl:apply-templates select="$attr" mode="add-attrs">
				<xsl:with-param name="namespace" select="$namespace" />
			</xsl:apply-templates>
			<!-- add validation attributes -->
			<xsl:apply-templates select="$ref/@*" mode="add-v-attributes"/>
			<xsl:apply-templates select="$ref/d:values" mode="dforms-e-choice-path">
				<xsl:with-param name="namespace" select="$namespace" />
				<xsl:with-param name="locale" select="$locale" />
				<xsl:with-param name="view" select="$view" />
				<xsl:with-param name="name" select="$name" />
				<xsl:with-param name="id" select="$id" />
				<xsl:with-param name="default-name" select="$default-name" />
				<xsl:with-param name="default-id" select="$default-id" />
				<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix" />
				<xsl:with-param name="disabled" select="$disabled" />
				<xsl:with-param name="model" select="$model" />
			</xsl:apply-templates>
		</xsl:element>
	</xsl:template>
	<xsl:template name="dforms-e-combo-option" match="@name[.='dforms-e-combo']" mode="dforms-e-choice">
		<xsl:param name="model" />
		<xsl:param name="ignore-ns-prefix" />
		<xsl:param name="value" />
		<xsl:param name="values" />
		<xsl:element name="option">
			<xsl:variable name="valueID">
				<xsl:call-template name="getChoiceValue">
					<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
					<xsl:with-param name="value" select="$value"/>
					<xsl:with-param name="path" select="$values/@value"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:attribute name="value"><xsl:value-of select="$valueID"/></xsl:attribute>
			<xsl:if test="$model and $model = $valueID">
				<xsl:attribute name="selected">selected</xsl:attribute>
			</xsl:if>
			<xsl:call-template name="getChoiceValue">
				<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
				<xsl:with-param name="value" select="$value"/>
				<xsl:with-param name="path" select="$values/@description"/>
			</xsl:call-template>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>